/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.misc.apiimpl;

import de.ellpeck.actuallyadditions.api.internal.IAtomicReconstructor;
import de.ellpeck.actuallyadditions.api.internal.IMethodHandler;
import de.ellpeck.actuallyadditions.api.lens.Lens;
import de.ellpeck.actuallyadditions.api.recipe.CoffeeIngredient;
import de.ellpeck.actuallyadditions.mod.ActuallyAdditions;
import de.ellpeck.actuallyadditions.mod.blocks.BlockLaserRelay;
import de.ellpeck.actuallyadditions.mod.crafting.CoffeeIngredientRecipe;
import de.ellpeck.actuallyadditions.mod.crafting.LaserRecipe;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityAtomicReconstructor;
import de.ellpeck.actuallyadditions.mod.util.StackUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class MethodHandler
implements IMethodHandler {
    @Override
    public boolean addEffectToStack(ItemStack stack, CoffeeIngredient ingredient) {
        MobEffectInstance[] effects;
        boolean worked = false;
        if (ingredient != null && (effects = ingredient.getEffects()) != null && effects.length > 0) {
            for (MobEffectInstance effect : effects) {
                MobEffectInstance effectHas = this.getSameEffectFromStack(stack, effect);
                if (effectHas != null) {
                    if (effectHas.m_19564_() >= ingredient.getMaxAmplifier() - 1) continue;
                    this.addEffectProperties(stack, effect, false, true);
                    worked = true;
                    continue;
                }
                this.addEffectToStack(stack, effect);
                worked = true;
            }
        }
        return worked;
    }

    @Override
    public boolean addRecipeEffectToStack(ItemStack stack, CoffeeIngredientRecipe ingredient) {
        List<MobEffectInstance> effects;
        boolean worked = false;
        if (ingredient != null && !(effects = ingredient.getEffects()).isEmpty()) {
            for (MobEffectInstance effect : effects) {
                MobEffectInstance effectHas = this.getSameEffectFromStack(stack, effect);
                if (effectHas != null) {
                    if (effectHas.m_19564_() >= ingredient.getMaxAmplifier() - 1) continue;
                    this.addEffectProperties(stack, effect, false, true);
                    worked = true;
                    continue;
                }
                this.addEffectToStack(stack, effect);
                worked = true;
            }
        }
        return worked;
    }

    @Override
    public MobEffectInstance getSameEffectFromStack(ItemStack stack, MobEffectInstance effect) {
        MobEffectInstance[] effectsStack = this.getEffectsFromStack(stack);
        if (effectsStack != null && effectsStack.length > 0) {
            for (MobEffectInstance effectStack : effectsStack) {
                if (effect.m_19544_() != effectStack.m_19544_()) continue;
                return effectStack;
            }
        }
        return null;
    }

    @Override
    public void addEffectProperties(ItemStack stack, MobEffectInstance effect, boolean addDur, boolean addAmp) {
        MobEffectInstance[] effects = this.getEffectsFromStack(stack);
        stack.m_41751_(new CompoundTag());
        for (int i = 0; i < effects.length; ++i) {
            if (effects[i].m_19544_() == effect.m_19544_()) {
                effects[i] = new MobEffectInstance(effects[i].m_19544_(), effects[i].m_19557_() + (addDur ? effect.m_19557_() : 0), effects[i].m_19564_() + (addAmp ? (effect.m_19564_() > 0 ? effect.m_19564_() : 1) : 0));
            }
            this.addEffectToStack(stack, effects[i]);
        }
    }

    @Override
    public void addEffectToStack(ItemStack stack, MobEffectInstance effect) {
        CompoundTag tag = stack.m_41784_();
        int prevCounter = tag.m_128451_("Counter");
        CompoundTag compound = new CompoundTag();
        compound.m_128359_("ID", BuiltInRegistries.f_256974_.m_7981_((Object)effect.m_19544_()).toString());
        compound.m_128405_("Duration", effect.m_19557_());
        compound.m_128405_("Amplifier", effect.m_19564_());
        int counter = prevCounter + 1;
        tag.m_128365_("" + counter, (Tag)compound);
        tag.m_128405_("Counter", counter);
        stack.m_41751_(tag);
    }

    @Override
    public MobEffectInstance[] getEffectsFromStack(ItemStack stack) {
        ArrayList<MobEffectInstance> effects = new ArrayList<MobEffectInstance>();
        CompoundTag tag = stack.m_41784_();
        for (int counter = tag.m_128451_("Counter"); counter > 0; --counter) {
            CompoundTag compound = tag.m_128469_("" + counter);
            String id = compound.m_128461_("ID");
            ResourceLocation effectID = id.isEmpty() ? new ResourceLocation("speed") : ResourceLocation.m_135820_((String)id);
            MobEffect effect = (MobEffect)BuiltInRegistries.f_256974_.m_7745_(effectID);
            if (effect == null) {
                ActuallyAdditions.LOGGER.error("Unable to find effect with ID: {}, defaulting to speed", (Object)effectID);
                effect = MobEffects.f_19596_;
            }
            MobEffectInstance effectInstance = new MobEffectInstance(effect, compound.m_128451_("Duration"), (int)compound.m_128445_("Amplifier"));
            effects.add(effectInstance);
        }
        return !effects.isEmpty() ? effects.toArray(new MobEffectInstance[0]) : null;
    }

    @Override
    public boolean invokeConversionLens(BlockState hitState, BlockPos hitBlock, IAtomicReconstructor tile) {
        if (hitBlock != null) {
            int range = 1;
            int rangeX = 0;
            int rangeY = 0;
            int rangeZ = 0;
            Direction facing = tile.getOrientation();
            if (facing != Direction.UP && facing != Direction.DOWN) {
                rangeY = range;
                if (facing == Direction.NORTH || facing == Direction.SOUTH) {
                    rangeX = range;
                } else {
                    rangeZ = range;
                }
            } else {
                rangeX = range;
                rangeZ = range;
            }
            for (int reachX = -rangeX; reachX <= rangeX; ++reachX) {
                block1: for (int reachZ = -rangeZ; reachZ <= rangeZ; ++reachZ) {
                    for (int reachY = -rangeY; reachY <= rangeY; ++reachY) {
                        ItemStack output;
                        Optional<LaserRecipe> recipe;
                        BlockState state;
                        BlockPos pos = new BlockPos(hitBlock.m_123341_() + reachX, hitBlock.m_123342_() + reachY, hitBlock.m_123343_() + reachZ);
                        if (tile.getWorldObject().m_46859_(pos) || (state = tile.getWorldObject().m_8055_(pos)).m_60734_() instanceof BlockLaserRelay || !(recipe = LaserRecipe.getRecipeForStack(new ItemStack((ItemLike)state.m_60734_()))).isPresent() || tile.getEnergy() < recipe.get().getEnergy() || (output = recipe.get().m_8043_(tile.getWorldObject().m_9598_()).m_41777_()).m_41619_()) continue;
                        tile.getWorldObject().m_46796_(2001, pos, Block.m_49956_((BlockState)state));
                        if (output.m_41720_() instanceof BlockItem) {
                            Block toPlace = Block.m_49814_((Item)output.m_41720_());
                            BlockState state2Place = toPlace.m_49966_();
                            tile.getWorldObject().m_7731_(pos, state2Place, 2);
                        } else {
                            ItemEntity item = new ItemEntity(tile.getWorldObject(), (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, output.m_41777_());
                            tile.getWorldObject().m_7967_((Entity)item);
                            tile.getWorldObject().m_46597_(pos, Blocks.f_50016_.m_49966_());
                        }
                        tile.extractEnergy(recipe.get().getEnergy());
                        continue block1;
                    }
                }
            }
            AABB aabb = new AABB((double)tile.getPosition().m_123341_(), (double)tile.getPosition().m_123342_(), (double)tile.getPosition().m_123343_(), (double)(hitBlock.m_123341_() + 1), (double)(hitBlock.m_123342_() + 1), (double)(hitBlock.m_123343_() + 1));
            Vec3i dir = tile.getOrientation().m_122436_();
            aabb = aabb.m_82377_(0.02, 0.02, 0.02).m_82363_((double)dir.m_123341_(), (double)dir.m_123342_(), (double)dir.m_123343_());
            List items = tile.getWorldObject().m_45976_(ItemEntity.class, aabb);
            for (ItemEntity item : items) {
                int itemsPossible;
                Optional<LaserRecipe> recipe;
                ItemStack stack = item.m_32055_();
                if (!item.m_6084_() || !StackUtil.isValid(stack) || item.getPersistentData().m_128471_("aa_cnv") || !(recipe = LaserRecipe.getRecipeForStack(stack)).isPresent() || (itemsPossible = Math.min(tile.getEnergy() / recipe.get().getEnergy(), stack.m_41613_())) <= 0) continue;
                item.m_146870_();
                if (stack.m_41613_() - itemsPossible > 0) {
                    ItemStack stackCopy = stack.m_41777_();
                    stackCopy.m_41774_(itemsPossible);
                    ItemEntity inputLeft = new ItemEntity(tile.getWorldObject(), item.m_20185_(), item.m_20186_(), item.m_20189_(), stackCopy);
                    tile.getWorldObject().m_7967_((Entity)inputLeft);
                }
                ItemStack outputCopy = recipe.get().m_8043_(tile.getWorldObject().m_9598_()).m_41777_();
                outputCopy.m_41764_(itemsPossible);
                ItemEntity newItem = new ItemEntity(tile.getWorldObject(), item.m_20185_(), item.m_20186_(), item.m_20189_(), outputCopy);
                newItem.getPersistentData().m_128379_("aa_cnv", true);
                tile.getWorldObject().m_7967_((Entity)newItem);
                tile.extractEnergy(recipe.get().getEnergy() * itemsPossible);
                break;
            }
            return !hitState.m_60795_();
        }
        return false;
    }

    @Override
    public boolean invokeReconstructor(IAtomicReconstructor tile) {
        if (tile.getEnergy() >= 1000) {
            Direction sideToManipulate = tile.getOrientation();
            Lens currentLens = tile.getLens();
            if (currentLens.canInvoke(tile, sideToManipulate, 1000)) {
                tile.extractEnergy(1000);
                int distance = currentLens.getDistance();
                for (int i = 0; i < distance; ++i) {
                    BlockPos hitBlock = tile.getPosition().m_5484_(sideToManipulate, i + 1);
                    if (!currentLens.invoke(tile.getWorldObject().m_8055_(hitBlock), hitBlock, tile) && i < distance - 1) continue;
                    TileEntityAtomicReconstructor.shootLaser(tile, tile.getWorldObject(), tile.getX(), tile.getY(), tile.getZ(), hitBlock.m_123341_(), hitBlock.m_123342_(), hitBlock.m_123343_(), currentLens);
                    break;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean addCrusherRecipes(List<ItemStack> inputs, List<ItemStack> outputOnes, int outputOneAmounts, List<ItemStack> outputTwos, int outputTwoAmounts, int outputTwoChance) {
        boolean hasWorkedOnce = false;
        return hasWorkedOnce;
    }

    @Override
    public boolean addCrusherRecipes(List<ItemStack> inputs, ItemStack outputOne, int outputOneAmount, ItemStack outputTwo, int outputTwoAmount, int outputTwoChance) {
        boolean hasWorkedOnce = false;
        return hasWorkedOnce;
    }
}

