/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.misc.apiimpl;

import de.ellpeck.actuallyadditions.api.laser.IConnectionPair;
import de.ellpeck.actuallyadditions.api.laser.LaserType;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;

public class ConnectionPair
implements IConnectionPair {
    private final BlockPos[] positions = new BlockPos[2];
    private boolean suppressConnectionRender;
    private LaserType type;

    public ConnectionPair() {
    }

    public ConnectionPair(BlockPos firstRelay, BlockPos secondRelay, LaserType type, boolean suppressConnectionRender) {
        this.positions[0] = firstRelay;
        this.positions[1] = secondRelay;
        this.suppressConnectionRender = suppressConnectionRender;
        this.type = type;
    }

    @Override
    public void readFromNBT(CompoundTag compound) {
        if (compound != null) {
            for (int i = 0; i < this.positions.length; ++i) {
                int anX = compound.m_128451_("x" + i);
                int aY = compound.m_128451_("y" + i);
                int aZ = compound.m_128451_("z" + i);
                this.positions[i] = new BlockPos(anX, aY, aZ);
            }
            this.suppressConnectionRender = compound.m_128471_("SuppressRender");
            String typeStrg = compound.m_128461_("Type");
            if (typeStrg != null && !typeStrg.isEmpty()) {
                this.type = LaserType.valueOf(typeStrg);
            }
        }
    }

    @Override
    public BlockPos[] getPositions() {
        return this.positions;
    }

    @Override
    public boolean doesSuppressRender() {
        return this.suppressConnectionRender;
    }

    @Override
    public LaserType getType() {
        return this.type;
    }

    @Override
    public boolean contains(BlockPos relay) {
        for (BlockPos position : this.positions) {
            if (position == null || !position.equals((Object)relay)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return (this.positions[0] == null ? "-" : this.positions[0].toString()) + " | " + (this.positions[1] == null ? "-" : this.positions[1].toString());
    }

    @Override
    public void writeToNBT(CompoundTag compound) {
        for (int i = 0; i < this.positions.length; ++i) {
            BlockPos relay = this.positions[i];
            compound.m_128405_("x" + i, relay.m_123341_());
            compound.m_128405_("y" + i, relay.m_123342_());
            compound.m_128405_("z" + i, relay.m_123343_());
        }
        if (this.type != null) {
            compound.m_128359_("Type", this.type.name());
        }
        compound.m_128379_("SuppressRender", this.suppressConnectionRender);
    }

    public boolean equals(Object obj) {
        if (obj instanceof ConnectionPair) {
            ConnectionPair pair = (ConnectionPair)obj;
            for (int i = 0; i < this.positions.length; ++i) {
                if (this.positions[i] != pair.positions[i] && (this.positions[i] == null || !this.positions[i].equals((Object)pair.positions[i]))) continue;
                return true;
            }
        }
        return super.equals(obj);
    }
}

