/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.lootmodifier;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.ellpeck.actuallyadditions.mod.config.CommonConfig;
import de.ellpeck.actuallyadditions.mod.items.ActuallyItems;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;

public class SolidXpLootModifier
extends LootModifier {
    public static final Supplier<Codec<SolidXpLootModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.create(inst -> SolidXpLootModifier.codecStart((RecordCodecBuilder.Instance)inst).apply((Applicative)inst, SolidXpLootModifier::new)));

    public SolidXpLootModifier(LootItemCondition[] conditionsIn) {
        super(conditionsIn);
    }

    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        RandomSource random = context.m_230907_();
        if (((Boolean)CommonConfig.Other.DO_XP_DROPS.get()).booleanValue()) {
            int looting = context.getLootingModifier();
            if (random.m_188503_(10) <= looting * 2) {
                generatedLoot.add((Object)new ItemStack((ItemLike)ActuallyItems.SOLIDIFIED_EXPERIENCE.get(), random.m_188503_(2 + looting) + 1));
            }
        }
        return generatedLoot;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return (Codec)CODEC.get();
    }
}

