/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.lootmodifier;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.ellpeck.actuallyadditions.mod.config.CommonConfig;
import de.ellpeck.actuallyadditions.mod.items.ActuallyItems;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.registries.RegistryObject;

public class GrassLootModifier
extends LootModifier {
    public static final Supplier<Codec<GrassLootModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.create(inst -> GrassLootModifier.codecStart((RecordCodecBuilder.Instance)inst).apply((Applicative)inst, GrassLootModifier::new)));
    private static final List<RegistryObject<Item>> seeds = List.of(ActuallyItems.RICE_SEEDS, ActuallyItems.COFFEE_BEANS, ActuallyItems.FLAX_SEEDS, ActuallyItems.CANOLA_SEEDS);

    public GrassLootModifier(LootItemCondition[] conditionsIn) {
        super(conditionsIn);
    }

    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        RandomSource random = context.m_230907_();
        if (((Boolean)CommonConfig.Other.DO_SEEDS_DROPS.get()).booleanValue()) {
            int looting = context.getLootingModifier();
            for (RegistryObject<Item> seed : seeds) {
                if (random.m_188503_(18) > looting * 2) continue;
                generatedLoot.add((Object)new ItemStack((ItemLike)seed.get(), random.m_188503_(1 + looting) + 1));
            }
        }
        return generatedLoot;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return (Codec)CODEC.get();
    }
}

