/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.lootmodifier;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.ellpeck.actuallyadditions.api.ActuallyTags;
import de.ellpeck.actuallyadditions.mod.blocks.ActuallyBlocks;
import de.ellpeck.actuallyadditions.mod.config.CommonConfig;
import de.ellpeck.actuallyadditions.mod.items.ActuallyItems;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;

public class DungeonLootModifier
extends LootModifier {
    public static final Supplier<Codec<DungeonLootModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.create(inst -> DungeonLootModifier.codecStart((RecordCodecBuilder.Instance)inst).apply((Applicative)inst, DungeonLootModifier::new)));

    public DungeonLootModifier(LootItemCondition[] conditionsIn) {
        super(conditionsIn);
    }

    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        RandomSource random = context.m_230907_();
        if (((Boolean)CommonConfig.Other.DUNGEON_LOOT.get()).booleanValue()) {
            int count;
            ResourceLocation lootTable = context.getQueriedLootTableId();
            boolean addCrystals = false;
            boolean addDrillCore = false;
            boolean addQuartz = false;
            boolean addBatWings = false;
            if (BuiltInLootTables.f_78742_.equals((Object)lootTable)) {
                addCrystals = true;
                addDrillCore = true;
                addQuartz = true;
            } else if (BuiltInLootTables.f_78759_.equals((Object)lootTable)) {
                addCrystals = true;
                addDrillCore = true;
            } else if (BuiltInLootTables.f_78743_.equals((Object)lootTable)) {
                addDrillCore = true;
                addQuartz = true;
            } else if (BuiltInLootTables.f_78761_.equals((Object)lootTable)) {
                addBatWings = true;
            } else if (BuiltInLootTables.f_78688_.equals((Object)lootTable)) {
                addBatWings = true;
            } else if (BuiltInLootTables.f_78764_.equals((Object)lootTable)) {
                addDrillCore = true;
                addBatWings = true;
            } else if (BuiltInLootTables.f_78760_.equals((Object)lootTable)) {
                addBatWings = true;
                addCrystals = true;
                addDrillCore = true;
            } else if (BuiltInLootTables.f_78741_.equals((Object)lootTable)) {
                addBatWings = true;
                addCrystals = true;
                addDrillCore = true;
                addQuartz = true;
            } else if (BuiltInLootTables.f_78689_.equals((Object)lootTable)) {
                addBatWings = true;
                addCrystals = true;
                addDrillCore = true;
                addQuartz = true;
            }
            if (addCrystals) {
                Item crystal;
                if (random.m_188503_(5) == 0) {
                    count = random.m_188503_(3) + 1;
                    crystal = this.getRandomItem(random, ActuallyTags.Items.CRYSTALS, (Item)ActuallyItems.RESTONIA_CRYSTAL.get());
                    generatedLoot.add((Object)new ItemStack((ItemLike)crystal, count));
                }
                if (random.m_188503_(15) == 0) {
                    count = random.m_188503_(3) + 1;
                    crystal = this.getRandomItem(random, ActuallyTags.Items.CRYSTAL_BLOCKS, (Item)ActuallyBlocks.RESTONIA_CRYSTAL.getItem());
                    generatedLoot.add((Object)new ItemStack((ItemLike)crystal, count));
                }
            }
            if (addDrillCore) {
                System.out.println("Deciding to add drill core or not");
                if (random.m_188503_(10) == 0) {
                    generatedLoot.add((Object)new ItemStack((ItemLike)ActuallyItems.DRILL_CORE.get()));
                }
            }
            if (addQuartz && random.m_188503_(5) == 0) {
                count = random.m_188503_(5) + 1;
                generatedLoot.add((Object)new ItemStack((ItemLike)ActuallyItems.BLACK_QUARTZ.get(), count));
            }
            if (addBatWings && random.m_188503_(10) == 0) {
                count = random.m_188503_(2) + 1;
                generatedLoot.add((Object)new ItemStack((ItemLike)ActuallyItems.BATS_WING.get(), count));
            }
        }
        return generatedLoot;
    }

    private Item getRandomItem(RandomSource random, TagKey<Item> tagKey, Item defaultItem) {
        Holder itemHolder;
        HolderSet.Named holderSet = BuiltInRegistries.f_257033_.m_203431_(tagKey).orElse(null);
        if (holderSet != null && (itemHolder = (Holder)holderSet.m_213653_(random).orElse(null)) != null) {
            return (Item)itemHolder.m_203334_();
        }
        return defaultItem;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return (Codec)CODEC.get();
    }
}

