/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.lootmodifier;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.ellpeck.actuallyadditions.mod.config.CommonConfig;
import de.ellpeck.actuallyadditions.mod.items.ActuallyItems;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.ambient.Bat;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;

public class BatLootModifier
extends LootModifier {
    public static final Supplier<Codec<BatLootModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.create(inst -> BatLootModifier.codecStart((RecordCodecBuilder.Instance)inst).apply((Applicative)inst, BatLootModifier::new)));

    public BatLootModifier(LootItemCondition[] conditionsIn) {
        super(conditionsIn);
    }

    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        RandomSource random = context.m_230907_();
        if (((Boolean)CommonConfig.Other.DO_BAT_DROPS.get()).booleanValue() && context.m_78936_(LootContextParams.f_81458_) && context.m_78936_(LootContextParams.f_81457_) && context.m_78936_(LootContextParams.f_81455_) && context.m_165124_(LootContextParams.f_81455_) instanceof Bat) {
            int looting = context.getLootingModifier();
            if (random.m_188503_(15) <= looting * 2) {
                generatedLoot.add((Object)new ItemStack((ItemLike)ActuallyItems.BATS_WING.get(), random.m_188503_(2 + looting) + 1));
            }
        }
        return generatedLoot;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return (Codec)CODEC.get();
    }
}

