/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.jei.coffee;

import com.google.common.base.Strings;
import de.ellpeck.actuallyadditions.api.ActuallyAdditionsAPI;
import de.ellpeck.actuallyadditions.api.ActuallyTags;
import de.ellpeck.actuallyadditions.mod.crafting.CoffeeIngredientRecipe;
import de.ellpeck.actuallyadditions.mod.items.ActuallyItems;
import de.ellpeck.actuallyadditions.mod.jei.JEIActuallyAdditionsPlugin;
import de.ellpeck.actuallyadditions.mod.util.AssetUtil;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class CoffeeMachineCategory
implements IRecipeCategory<CoffeeIngredientRecipe> {
    private final IDrawableStatic background;

    public CoffeeMachineCategory(IGuiHelper helper) {
        this.background = helper.drawableBuilder(AssetUtil.getGuiLocation("gui_nei_coffee_machine"), 0, 0, 126, 92).setTextureSize(256, 256).build();
    }

    public RecipeType<CoffeeIngredientRecipe> getRecipeType() {
        return JEIActuallyAdditionsPlugin.COFFEE_MACHINE;
    }

    public Component getTitle() {
        return Component.m_237115_((String)"container.actuallyadditions.coffeeMachine");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return null;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, CoffeeIngredientRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 2, 39).addIngredients(Ingredient.m_204132_(ActuallyTags.Items.COFFEE_BEANS));
        builder.addSlot(RecipeIngredientRole.INPUT, 90, 21).addIngredients(recipe.getIngredient());
        builder.addSlot(RecipeIngredientRole.INPUT, 45, 39).addItemStack(new ItemStack((ItemLike)ActuallyItems.EMPTY_CUP.get()));
        ItemStack output = new ItemStack((ItemLike)ActuallyItems.COFFEE_CUP.get());
        ActuallyAdditionsAPI.methodHandler.addRecipeEffectToStack(output, recipe);
        builder.addSlot(RecipeIngredientRole.OUTPUT, 45, 70).addItemStack(output);
    }

    public void draw(CoffeeIngredientRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        super.draw((Object)recipe, recipeSlotsView, guiGraphics, mouseX, mouseY);
        Minecraft mc = Minecraft.m_91087_();
        if (!Strings.isNullOrEmpty((String)recipe.getExtraText())) {
            guiGraphics.m_280614_(mc.f_91062_, (Component)Component.m_237115_((String)"jei.actuallyadditions.coffee.special").m_130946_(":"), 2, 4, 0x404040, false);
            guiGraphics.m_280614_(mc.f_91062_, (Component)Component.m_237115_((String)recipe.getExtraText()), 2, 16, 0x404040, false);
        }
        if (recipe.getMaxAmplifier() > 0) {
            guiGraphics.m_280614_(mc.f_91062_, (Component)Component.m_237115_((String)"jei.actuallyadditions.coffee.maxAmount").m_130946_(": " + recipe.getMaxAmplifier()), 2, 28, 0x404040, false);
        }
    }
}

