/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.items.lens;

import de.ellpeck.actuallyadditions.api.internal.IAtomicReconstructor;
import de.ellpeck.actuallyadditions.api.lens.Lens;
import de.ellpeck.actuallyadditions.mod.util.ItemUtil;
import de.ellpeck.actuallyadditions.mod.util.StackUtil;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class LensDisenchanting
extends Lens {
    public static final int ENERGY_USE = 250000;

    @Override
    public boolean invoke(BlockState hitState, BlockPos hitBlock, IAtomicReconstructor tile) {
        List items;
        if (tile.getEnergy() >= 250000 && (items = tile.getWorldObject().m_45976_(ItemEntity.class, new AABB((double)hitBlock.m_123341_(), (double)hitBlock.m_123342_(), (double)hitBlock.m_123343_(), (double)(hitBlock.m_123341_() + 1), (double)(hitBlock.m_123342_() + 1), (double)(hitBlock.m_123343_() + 1)))) != null && !items.isEmpty()) {
            ItemEntity book = null;
            ItemEntity toDisenchant = null;
            for (ItemEntity item : items) {
                ItemStack stack;
                if (item == null || !item.m_6084_() || !StackUtil.isValid(stack = item.m_32055_()) || stack.m_41613_() != 1) continue;
                Item stackItem = stack.m_41720_();
                if (stackItem == Items.f_42517_ || stackItem == Items.f_42690_) {
                    if (book == null) {
                        book = item;
                        continue;
                    }
                    return false;
                }
                Map enchants = EnchantmentHelper.m_44831_((ItemStack)stack);
                if (enchants == null || enchants.isEmpty()) continue;
                if (toDisenchant == null) {
                    toDisenchant = item;
                    continue;
                }
                return false;
            }
            if (book != null && toDisenchant != null) {
                ItemStack disenchantStack = toDisenchant.m_32055_();
                ItemStack bookStack = book.m_32055_();
                Map enchants = EnchantmentHelper.m_44831_((ItemStack)disenchantStack);
                if (!enchants.isEmpty()) {
                    Enchantment enchant = (Enchantment)enchants.keySet().iterator().next();
                    int level = (Integer)enchants.get(enchant);
                    ItemStack newDisenchantStack = disenchantStack.m_41777_();
                    ItemStack newBookStack = bookStack.m_41720_() == Items.f_42517_ ? new ItemStack((ItemLike)Items.f_42690_) : bookStack.m_41777_();
                    ItemUtil.removeEnchantment(newDisenchantStack, enchant);
                    EnchantedBookItem.m_41153_((ItemStack)newBookStack, (EnchantmentInstance)new EnchantmentInstance(enchant, level));
                    ItemEntity disenchanted = new ItemEntity(toDisenchant.m_20193_(), toDisenchant.m_20185_(), toDisenchant.m_20186_(), toDisenchant.m_20189_(), newDisenchantStack);
                    ItemEntity newBook = new ItemEntity(book.m_20193_(), book.m_20185_(), book.m_20186_(), book.m_20189_(), newBookStack);
                    toDisenchant.m_146870_();
                    book.m_146870_();
                    tile.getWorldObject().m_7967_((Entity)newBook);
                    tile.getWorldObject().m_7967_((Entity)disenchanted);
                    tile.extractEnergy(250000);
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public int getColor() {
        return 15445503;
    }

    @Override
    public int getDistance() {
        return 5;
    }

    @Override
    public boolean canInvoke(IAtomicReconstructor tile, Direction sideToShootTo, int energyUsePerShot) {
        return tile.getEnergy() - energyUsePerShot >= 250000;
    }
}

