/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.items.base;

import de.ellpeck.actuallyadditions.mod.items.ActuallyItems;
import de.ellpeck.actuallyadditions.mod.items.base.ItemBase;
import de.ellpeck.actuallyadditions.mod.tile.CustomItemEnergyStorage;
import de.ellpeck.actuallyadditions.mod.util.AssetUtil;
import java.text.NumberFormat;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.loading.FMLEnvironment;

public abstract class ItemEnergy
extends ItemBase {
    private final int maxPower;
    private final int transfer;

    public ItemEnergy(int maxPower, int transfer) {
        super(ActuallyItems.defaultProps().m_41487_(1));
        this.maxPower = maxPower;
        this.transfer = transfer;
    }

    public ItemEnergy(Item.Properties props, int maxPower, int transfer) {
        super(props);
        this.maxPower = maxPower;
        this.transfer = transfer;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        int energy = 0;
        if (stack.m_41782_() && stack.m_41783_().m_128441_("Energy")) {
            energy = stack.m_41783_().m_128451_("Energy");
        }
        NumberFormat format = NumberFormat.getInstance();
        tooltip.add((Component)Component.m_237110_((String)"misc.actuallyadditions.power_long", (Object[])new Object[]{format.format(energy), format.format(this.maxPower)}).m_130940_(ChatFormatting.GRAY));
    }

    public boolean m_5812_(ItemStack stack) {
        return false;
    }

    public boolean m_142522_(ItemStack itemStack) {
        return true;
    }

    public int m_142158_(ItemStack stack) {
        if (stack.m_41782_() && stack.m_41783_().m_128441_("Energy")) {
            return (int)(stack.m_41783_().m_128459_("Energy") / (double)this.maxPower * 13.0);
        }
        return 1;
    }

    public int m_142159_(ItemStack stack) {
        int defaultColor = super.m_142159_(stack);
        if (FMLEnvironment.dist.isClient()) {
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91074_ == null) {
                return defaultColor;
            }
            float[] color = AssetUtil.getWheelColor(mc.f_91074_.m_9236_().m_46467_() % 256L);
            return Mth.m_14159_((float)(color[0] / 255.0f), (float)(color[1] / 255.0f), (float)(color[2] / 255.0f));
        }
        return defaultColor;
    }

    public void setEnergy(ItemStack stack, int energy) {
        stack.getCapability(ForgeCapabilities.ENERGY, null).ifPresent(cap -> {
            if (cap instanceof CustomItemEnergyStorage) {
                ((CustomItemEnergyStorage)((Object)cap)).setEnergyStored(energy);
            }
        });
    }

    @Deprecated
    public int receiveEnergyInternal(ItemStack stack, int maxReceive, boolean simulate) {
        return stack.getCapability(ForgeCapabilities.ENERGY).map(cap -> ((CustomItemEnergyStorage)((Object)cap)).receiveEnergyInternal(maxReceive, simulate)).orElse(0);
    }

    public int extractEnergyInternal(ItemStack stack, int maxExtract, boolean simulate) {
        return stack.getCapability(ForgeCapabilities.ENERGY).map(cap -> cap instanceof CustomItemEnergyStorage ? ((CustomItemEnergyStorage)((Object)cap)).extractEnergyInternal(maxExtract, simulate) : 0).orElse(0);
    }

    @Deprecated
    public int receiveEnergy(ItemStack stack, int maxReceive, boolean simulate) {
        return stack.getCapability(ForgeCapabilities.ENERGY).map(cap -> cap.receiveEnergy(maxReceive, simulate)).orElse(0);
    }

    public int extractEnergy(ItemStack stack, int maxExtract, boolean simulate) {
        return stack.getCapability(ForgeCapabilities.ENERGY).map(cap -> cap.extractEnergy(maxExtract, simulate)).orElse(0);
    }

    public int getEnergyStored(ItemStack stack) {
        return stack.getCapability(ForgeCapabilities.ENERGY, null).map(IEnergyStorage::getEnergyStored).orElse(0);
    }

    public int getMaxEnergyStored(ItemStack stack) {
        return stack.getCapability(ForgeCapabilities.ENERGY, null).map(IEnergyStorage::getMaxEnergyStored).orElse(0);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundTag nbt) {
        return new EnergyCapabilityProvider(stack, this);
    }

    private static class EnergyCapabilityProvider
    implements ICapabilityProvider {
        public final CustomItemEnergyStorage storage;
        private final LazyOptional<CustomItemEnergyStorage> energyCapability;

        public EnergyCapabilityProvider(ItemStack stack, ItemEnergy item) {
            this.storage = new CustomItemEnergyStorage(stack, item.maxPower, item.transfer, item.transfer);
            this.energyCapability = LazyOptional.of(() -> this.storage);
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
            if (cap == ForgeCapabilities.ENERGY) {
                return this.energyCapability.cast();
            }
            return LazyOptional.empty();
        }
    }
}

