/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.items;

import de.ellpeck.actuallyadditions.mod.inventory.SackContainer;
import de.ellpeck.actuallyadditions.mod.inventory.VoidSackContainer;
import de.ellpeck.actuallyadditions.mod.items.ActuallyItems;
import de.ellpeck.actuallyadditions.mod.items.DrillItem;
import de.ellpeck.actuallyadditions.mod.items.base.ItemBase;
import de.ellpeck.actuallyadditions.mod.sack.SackData;
import de.ellpeck.actuallyadditions.mod.sack.SackManager;
import de.ellpeck.actuallyadditions.mod.util.ItemStackHandlerAA;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.network.NetworkHooks;

public class Sack
extends ItemBase {
    public final boolean isVoid;

    public Sack(boolean isVoid) {
        super(ActuallyItems.defaultProps().m_41487_(1));
        this.isVoid = isVoid;
    }

    public InteractionResult m_6225_(UseOnContext context) {
        BlockEntity tile;
        ItemStack stack = context.m_43723_().m_21120_(context.m_43724_());
        if (!this.isVoid && (tile = context.m_43725_().m_7702_(context.m_8083_())) != null) {
            if (!context.m_43725_().f_46443_) {
                ItemStackHandlerAA inv = new ItemStackHandlerAA(28);
                boolean changed = tile.getCapability(ForgeCapabilities.ITEM_HANDLER, context.m_43719_()).map(cap -> {
                    boolean localChanged = false;
                    DrillItem.loadSlotsFromNBT((IItemHandlerModifiable)inv, stack);
                    block0: for (int j = 0; j < inv.getSlots(); ++j) {
                        ItemStack invStack = inv.getStackInSlot(j);
                        if (invStack.m_41619_()) continue;
                        for (int i = 0; i < cap.getSlots(); ++i) {
                            ItemStack remain = cap.insertItem(i, invStack, false);
                            if (ItemStack.m_41728_((ItemStack)remain, (ItemStack)invStack)) continue;
                            inv.setStackInSlot(j, remain.m_41777_());
                            localChanged = true;
                            if (remain.m_41619_()) continue block0;
                            invStack = remain;
                        }
                    }
                    return localChanged;
                }).orElse(false);
                if (changed) {
                    DrillItem.writeSlotsToNBT((IItemHandler)inv, stack);
                }
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, @Nonnull InteractionHand hand) {
        ItemStack sackStack = player.m_21120_(hand);
        if (!world.f_46443_ && hand == InteractionHand.MAIN_HAND && sackStack.m_41720_() instanceof Sack && player instanceof ServerPlayer) {
            if (!this.isVoid) {
                SackData data = Sack.getData(sackStack);
                if (data == null) {
                    return InteractionResultHolder.m_19100_((Object)sackStack);
                }
                UUID uuid = data.getUuid();
                data.updateAccessRecords(player.m_7755_().getString(), System.currentTimeMillis());
                NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)new SimpleMenuProvider((id, inv, entity) -> new SackContainer(id, inv, data.getSpecialHandler(), data.getFilter()), sackStack.m_41786_()), buffer -> buffer.m_130077_(uuid));
            } else {
                player.m_5893_((MenuProvider)new SimpleMenuProvider((id, inv, entity) -> new VoidSackContainer(id, inv), sackStack.m_41786_()));
            }
        }
        return InteractionResultHolder.m_19098_((Object)player.m_21120_(hand));
    }

    public static SackData getData(ItemStack stack) {
        UUID uuid;
        if (!(stack.m_41720_() instanceof Sack)) {
            return null;
        }
        CompoundTag tag = stack.m_41784_();
        if (!tag.m_128441_("UUID")) {
            uuid = UUID.randomUUID();
            tag.m_128362_("UUID", uuid);
        } else {
            uuid = tag.m_128342_("UUID");
        }
        return SackManager.get().getOrCreateSack(uuid);
    }
}

