/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.items;

import de.ellpeck.actuallyadditions.mod.config.CommonConfig;
import de.ellpeck.actuallyadditions.mod.items.ActuallyItems;
import de.ellpeck.actuallyadditions.mod.items.base.ItemBase;
import de.ellpeck.actuallyadditions.mod.util.StackUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ItemWaterBowl
extends ItemBase {
    public ItemWaterBowl() {
        super(ActuallyItems.defaultProps().m_41487_(1));
    }

    @SubscribeEvent
    public void onPlayerInteractEvent(PlayerInteractEvent.RightClickItem event) {
        if (event.getLevel() != null && ((Boolean)CommonConfig.Other.WATER_BOWL.get()).booleanValue() && !event.getItemStack().m_41619_() && event.getItemStack().m_150930_(Items.f_42399_)) {
            BlockState state;
            BlockHitResult trace = ItemWaterBowl.m_41435_((Level)event.getLevel(), (Player)event.getEntity(), (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
            if (trace.m_6662_() != HitResult.Type.BLOCK) {
                return;
            }
            InteractionResultHolder result = ForgeEventFactory.onBucketUse((Player)event.getEntity(), (Level)event.getLevel(), (ItemStack)event.getItemStack(), (HitResult)trace);
            if (result == null && event.getEntity().m_36204_(trace.m_82425_().m_121945_(trace.m_82434_()), trace.m_82434_(), event.getItemStack()) && (state = event.getLevel().m_8055_(trace.m_82425_())).m_60819_().m_192917_((Fluid)Fluids.f_76193_) && (Integer)state.m_61143_((Property)BlockStateProperties.f_61422_) == 0) {
                event.getEntity().m_5496_(SoundEvents.f_11781_, 1.0f, 1.0f);
                if (!event.getLevel().f_46443_) {
                    event.getLevel().m_7731_(trace.m_82425_(), Blocks.f_50016_.m_49966_(), 11);
                    ItemStack reduced = StackUtil.shrink(event.getItemStack(), 1);
                    ItemStack bowl = new ItemStack((ItemLike)ActuallyItems.WATER_BOWL.get());
                    if (!StackUtil.isValid(reduced)) {
                        event.getEntity().m_21008_(event.getHand(), bowl);
                    } else if (!event.getEntity().m_150109_().m_36054_(bowl.m_41777_())) {
                        ItemEntity entityItem = new ItemEntity(event.getLevel(), event.getEntity().m_20185_(), event.getEntity().m_20186_(), event.getEntity().m_20189_(), bowl.m_41777_());
                        entityItem.m_32010_(0);
                        event.getLevel().m_7967_((Entity)entityItem);
                    }
                }
            }
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        BlockPos pos1;
        HitResult trace;
        ItemStack stack = player.m_21120_(hand);
        InteractionResultHolder result = ForgeEventFactory.onBucketUse((Player)player, (Level)world, (ItemStack)stack, (HitResult)(trace = player.m_19907_(8.0, 1.0f, false)));
        if (result != null) {
            return result;
        }
        if (trace == null) {
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        if (trace.m_6662_() != HitResult.Type.BLOCK) {
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        BlockHitResult blockTrace = (BlockHitResult)trace;
        BlockPos pos = blockTrace.m_82425_();
        if (!world.m_7966_(player, pos)) {
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        BlockPos blockPos = pos1 = world.m_8055_(pos).m_247087_() && blockTrace.m_82434_() == Direction.UP ? pos : pos.m_121945_(blockTrace.m_82434_());
        if (!player.m_36204_(pos1, blockTrace.m_82434_(), stack)) {
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        if (this.tryPlaceContainedLiquid(player, world, pos1, false)) {
            return !player.m_7500_() ? InteractionResultHolder.m_19090_((Object)new ItemStack((ItemLike)Items.f_42399_)) : InteractionResultHolder.m_19090_((Object)stack);
        }
        return InteractionResultHolder.m_19100_((Object)stack);
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int itemSlot, boolean isSelected) {
        if (!world.f_46443_ && ((Boolean)CommonConfig.Other.WATER_BOWL_LOSS.get()).booleanValue() && world.m_46467_() % 10L == 0L && world.f_46441_.m_188501_() >= 0.5f) {
            int lastX = 0;
            int lastY = 0;
            if (stack.m_41782_()) {
                CompoundTag compound = stack.m_41784_();
                lastX = compound.m_128451_("lastX");
                lastY = compound.m_128451_("lastY");
            }
            boolean change = false;
            if (lastX != 0 && lastX != (int)entity.m_20185_() || lastY != 0 && lastY != (int)entity.m_20186_()) {
                Player player;
                if (!entity.m_6144_() && entity instanceof Player && this.tryPlaceContainedLiquid(player = (Player)entity, world, player.m_20183_(), true)) {
                    this.checkReplace(player, stack, new ItemStack((ItemLike)Items.f_42399_), itemSlot);
                }
                change = true;
            }
            if (change || lastX == 0 || lastY == 0) {
                CompoundTag compound = stack.m_41784_();
                compound.m_128405_("lastX", (int)entity.m_20185_());
                compound.m_128405_("lastY", (int)entity.m_20186_());
            }
        }
    }

    private void checkReplace(Player player, ItemStack old, ItemStack stack, int slot) {
        if (player.m_150109_().m_8020_(slot) == old) {
            player.m_150109_().m_6836_(slot, stack);
        } else if (player.m_150109_().f_35976_.get(slot) == old) {
            player.m_150109_().f_35976_.set(slot, (Object)stack);
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return !ItemStack.m_41656_((ItemStack)oldStack, (ItemStack)newStack);
    }

    public boolean tryPlaceContainedLiquid(Player player, Level world, BlockPos pos, boolean finite) {
        BlockState state = world.m_8055_(pos);
        boolean nonSolid = !state.m_280296_();
        boolean replaceable = state.m_247087_();
        if (!(world.m_46859_(pos) || nonSolid || replaceable)) {
            return false;
        }
        if (world.m_6042_().f_63857_()) {
            world.m_5594_(player, pos, SoundEvents.f_11937_, SoundSource.BLOCKS, 0.5f, 2.6f + (world.f_46441_.m_188501_() - world.f_46441_.m_188501_()) * 0.8f);
            for (int k = 0; k < 8; ++k) {
                world.m_7106_((ParticleOptions)ParticleTypes.f_123755_, (double)pos.m_123341_() + Math.random(), (double)pos.m_123342_() + Math.random(), (double)pos.m_123343_() + Math.random(), 0.0, 0.0, 0.0);
            }
        } else {
            if (!world.f_46443_ && (nonSolid || replaceable) && world.m_6425_(pos).m_76178_()) {
                world.m_46961_(pos, true);
            }
            world.m_5594_(player, pos, SoundEvents.f_11778_, SoundSource.BLOCKS, 1.0f, 1.0f);
            BlockState placeState = Blocks.f_49990_.m_49966_();
            world.m_7731_(pos, placeState, 3);
        }
        return true;
    }
}

