/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.items;

import de.ellpeck.actuallyadditions.api.tile.IPhantomTile;
import de.ellpeck.actuallyadditions.mod.items.ActuallyItems;
import de.ellpeck.actuallyadditions.mod.items.base.ItemBase;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityBase;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemPhantomConnector
extends ItemBase {
    public ItemPhantomConnector() {
        super(ActuallyItems.defaultNonStacking());
    }

    public static ResourceKey<Level> getStoredWorld(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        if (!tag.m_128441_("WorldOfTileStored")) {
            return null;
        }
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(tag.m_128461_("WorldOfTileStored")));
    }

    public static BlockPos getStoredPosition(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        int x = tag.m_128451_("XCoordOfTileStored");
        int y = tag.m_128451_("YCoordOfTileStored");
        int z = tag.m_128451_("ZCoordOfTileStored");
        if (x != 0 || y != 0 || z != 0) {
            return new BlockPos(x, y, z);
        }
        return null;
    }

    public static void clearStorage(ItemStack stack, String ... keys) {
        CompoundTag compound = stack.m_41784_();
        for (String key : keys) {
            compound.m_128473_(key);
        }
    }

    public static void storeConnection(ItemStack stack, int x, int y, int z, Level world) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128405_("XCoordOfTileStored", x);
        tag.m_128405_("YCoordOfTileStored", y);
        tag.m_128405_("ZCoordOfTileStored", z);
        tag.m_128359_("WorldOfTileStored", world.m_46472_().m_135782_().toString());
    }

    public InteractionResult m_6225_(UseOnContext context) {
        ItemStack stack = context.m_43723_().m_21120_(context.m_43724_());
        if (!context.m_43725_().f_46443_) {
            BlockPos pos = context.m_8083_();
            BlockEntity tile = context.m_43725_().m_7702_(pos);
            if (tile != null && tile instanceof IPhantomTile) {
                BlockPos stored = ItemPhantomConnector.getStoredPosition(stack);
                if (stored != null && ItemPhantomConnector.getStoredWorld(stack) == context.m_43725_().m_46472_()) {
                    ((IPhantomTile)tile).setBoundPosition(stored);
                    if (tile instanceof TileEntityBase) {
                        ((TileEntityBase)tile).sendUpdate();
                    }
                    ItemPhantomConnector.clearStorage(stack, "XCoordOfTileStored", "YCoordOfTileStored", "ZCoordOfTileStored", "WorldOfTileStored");
                    context.m_43723_().m_5661_((Component)Component.m_237115_((String)"tooltip.actuallyadditions.phantom.connected.desc"), true);
                    return InteractionResult.SUCCESS;
                }
                return InteractionResult.FAIL;
            }
            ItemPhantomConnector.storeConnection(stack, pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), context.m_43725_());
            context.m_43723_().m_5661_((Component)Component.m_237115_((String)"tooltip.actuallyadditions.phantom.stored.desc"), true);
        }
        return InteractionResult.SUCCESS;
    }

    @Nullable
    public CompoundTag getShareTag(ItemStack stack) {
        return new CompoundTag();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level playerIn, List<Component> list, TooltipFlag advanced) {
        BlockPos coords = ItemPhantomConnector.getStoredPosition(stack);
        if (coords != null) {
            list.add((Component)Component.m_237115_((String)"tooltip.actuallyadditions.boundTo.desc").m_130946_(":"));
            list.add((Component)Component.m_237113_((String)("X: " + coords.m_123341_())));
            list.add((Component)Component.m_237113_((String)("Y: " + coords.m_123342_())));
            list.add((Component)Component.m_237113_((String)("Z: " + coords.m_123343_())));
            list.add((Component)Component.m_237115_((String)"tooltip.actuallyadditions.clearStorage.desc").m_130940_(ChatFormatting.ITALIC));
        }
    }
}

