/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.items;

import de.ellpeck.actuallyadditions.api.misc.IDisplayStandItem;
import de.ellpeck.actuallyadditions.mod.items.ActuallyItems;
import de.ellpeck.actuallyadditions.mod.items.base.ItemBase;
import java.util.ArrayList;
import java.util.Collections;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.IForgeShearable;

public class ItemLeafBlower
extends ItemBase
implements IDisplayStandItem {
    private final boolean isAdvanced;

    public ItemLeafBlower(boolean isAdvanced) {
        super(ActuallyItems.defaultProps().m_41487_(1));
        this.isAdvanced = isAdvanced;
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(@Nonnull Level world, Player player, @Nonnull InteractionHand hand) {
        player.m_6672_(hand);
        return InteractionResultHolder.m_19090_((Object)player.m_21120_(hand));
    }

    @Nonnull
    public UseAnim m_6164_(@Nonnull ItemStack stack) {
        return UseAnim.BOW;
    }

    public int m_8105_(@Nonnull ItemStack stack) {
        return Integer.MAX_VALUE;
    }

    public void m_5929_(Level level, LivingEntity livingEntity, ItemStack stack, int remainingUseDuration) {
        this.doUpdate(level, Mth.m_14107_((double)livingEntity.m_20185_()), Mth.m_14107_((double)livingEntity.m_20186_()), Mth.m_14107_((double)livingEntity.m_20189_()), remainingUseDuration, stack);
    }

    private boolean doUpdate(Level world, int x, int y, int z, int time, ItemStack stack) {
        if (!world.f_46443_ && time <= this.m_8105_(stack) && (this.isAdvanced || time % 3 == 0)) {
            boolean broke = this.breakStuff(world, x, y, z);
            world.m_6263_(null, (double)x, (double)y, (double)z, SoundEvents.f_12070_, SoundSource.PLAYERS, 0.2f, 0.001f);
            return broke;
        }
        return false;
    }

    public boolean breakStuff(Level world, int x, int y, int z) {
        ArrayList<BlockPos> breakPositions = new ArrayList<BlockPos>();
        int rangeSides = 5;
        int rangeUp = 1;
        for (int reachX = -rangeSides; reachX < rangeSides + 1; ++reachX) {
            for (int reachZ = -rangeSides; reachZ < rangeSides + 1; ++reachZ) {
                for (int reachY = this.isAdvanced ? -rangeSides : -rangeUp; reachY < (this.isAdvanced ? rangeSides : rangeUp) + 1; ++reachY) {
                    BlockPos pos = new BlockPos(x + reachX, y + reachY, z + reachZ);
                    Block block = world.m_8055_(pos).m_60734_();
                    if (!(block instanceof BushBlock) && !(block instanceof IForgeShearable) || !this.isAdvanced && block instanceof LeavesBlock) continue;
                    breakPositions.add(pos);
                }
            }
        }
        if (!breakPositions.isEmpty()) {
            Collections.shuffle(breakPositions);
            BlockPos pos = (BlockPos)breakPositions.get(0);
            BlockState theState = world.m_8055_(pos);
            world.m_46961_(pos, true);
            world.m_46796_(2001, pos, Block.m_49956_((BlockState)theState));
            world.m_46597_(pos, Blocks.f_50016_.m_49966_());
            return true;
        }
        return false;
    }

    @Override
    public boolean update(ItemStack stack, BlockEntity tile, int elapsedTicks) {
        return this.doUpdate(tile.m_58904_(), tile.m_58899_().m_123341_(), tile.m_58899_().m_123342_(), tile.m_58899_().m_123343_(), elapsedTicks, stack);
    }

    @Override
    public int getUsePerTick(ItemStack stack, BlockEntity tile, int elapsedTicks) {
        return 60;
    }
}

