/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.items;

import de.ellpeck.actuallyadditions.api.ActuallyAdditionsAPI;
import de.ellpeck.actuallyadditions.mod.items.ActuallyItems;
import de.ellpeck.actuallyadditions.mod.items.ItemPhantomConnector;
import de.ellpeck.actuallyadditions.mod.items.base.ItemBase;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityLaserRelay;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemLaserWrench
extends ItemBase {
    public ItemLaserWrench() {
        super(ActuallyItems.defaultNonStacking());
    }

    public InteractionResult m_6225_(UseOnContext context) {
        BlockPos pos = context.m_8083_();
        Level world = context.m_43725_();
        Player player = context.m_43723_();
        ItemStack stack = player.m_21120_(context.m_43724_());
        BlockEntity tile = world.m_7702_(pos);
        if (tile instanceof TileEntityLaserRelay) {
            TileEntityLaserRelay relay = (TileEntityLaserRelay)tile;
            if (!world.f_46443_) {
                if (ItemPhantomConnector.getStoredPosition(stack) == null) {
                    ItemPhantomConnector.storeConnection(stack, pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), world);
                    player.m_5661_((Component)Component.m_237115_((String)"tooltip.actuallyadditions.laser.stored.desc"), true);
                } else {
                    BlockPos savedPos = ItemPhantomConnector.getStoredPosition(stack);
                    if (savedPos != null) {
                        BlockEntity savedTile = world.m_7702_(savedPos);
                        if (savedTile instanceof TileEntityLaserRelay) {
                            TileEntityLaserRelay savedRelay = (TileEntityLaserRelay)savedTile;
                            int distanceSq = (int)savedPos.m_123331_((Vec3i)pos);
                            int lowestRange = Math.min(relay.getMaxRange(), savedRelay.getMaxRange());
                            int range = lowestRange * lowestRange;
                            if (ItemPhantomConnector.getStoredWorld(stack) == world.m_46472_() && savedRelay.type == relay.type && distanceSq <= range && ActuallyAdditionsAPI.connectionHandler.addConnection(savedPos, pos, relay.type, world, false, true)) {
                                ItemPhantomConnector.clearStorage(stack, "XCoordOfTileStored", "YCoordOfTileStored", "ZCoordOfTileStored", "WorldOfTileStored");
                                ((TileEntityLaserRelay)savedTile).sendUpdate();
                                relay.sendUpdate();
                                player.m_5661_((Component)Component.m_237115_((String)"tooltip.actuallyadditions.laser.connected.desc"), true);
                                return InteractionResult.SUCCESS;
                            }
                        }
                        player.m_5661_((Component)Component.m_237115_((String)"tooltip.actuallyadditions.laser.cantConnect.desc"), false);
                        ItemPhantomConnector.clearStorage(stack, "XCoordOfTileStored", "YCoordOfTileStored", "ZCoordOfTileStored", "WorldOfTileStored");
                    }
                }
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level playerIn, List<Component> list, TooltipFlag advanced) {
        BlockPos coords = ItemPhantomConnector.getStoredPosition(stack);
        if (coords != null) {
            list.add((Component)Component.m_237115_((String)"tooltip.actuallyadditions.boundTo.desc").m_130946_(":"));
            list.add((Component)Component.m_237113_((String)("X: " + coords.m_123341_())));
            list.add((Component)Component.m_237113_((String)("Y: " + coords.m_123342_())));
            list.add((Component)Component.m_237113_((String)("Z: " + coords.m_123343_())));
            list.add((Component)Component.m_237115_((String)"tooltip.actuallyadditions.clearStorage.desc").m_130940_(ChatFormatting.ITALIC));
        }
    }
}

