/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.items;

import de.ellpeck.actuallyadditions.api.misc.IGoggles;
import de.ellpeck.actuallyadditions.mod.items.ActuallyItems;
import de.ellpeck.actuallyadditions.mod.items.base.ItemArmorAA;
import de.ellpeck.actuallyadditions.mod.material.ArmorMaterials;
import io.netty.util.internal.ConcurrentSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;

public class ItemEngineerGoggles
extends ItemArmorAA
implements IGoggles {
    private final Set<Entity> cachedGlowingEntities = new ConcurrentSet();
    private final boolean displayMobs;

    public ItemEngineerGoggles(boolean displayMobs) {
        super(ArmorMaterials.GOGGLES, ArmorItem.Type.HELMET, ActuallyItems.defaultProps().setNoRepair().m_41503_(0));
        this.displayMobs = displayMobs;
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> MinecraftForge.EVENT_BUS.register((Object)this));
    }

    public static boolean isWearing(Player player) {
        ItemStack face = (ItemStack)player.m_150109_().f_35975_.get(3);
        return !face.m_41619_() && face.m_41720_() instanceof IGoggles;
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        ItemStack face;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null && ItemEngineerGoggles.isWearing((Player)player) && ((IGoggles)(face = (ItemStack)player.m_150109_().f_35975_.get(3)).m_41720_()).displaySpectralMobs()) {
            double range = 8.0;
            AABB aabb = new AABB(player.m_20185_() - range, player.m_20186_() - range, player.m_20189_() - range, player.m_20185_() + range, player.m_20186_() + range, player.m_20189_() + range);
            List entities = player.m_9236_().m_45976_(Entity.class, aabb);
            if (entities != null && !entities.isEmpty()) {
                this.cachedGlowingEntities.addAll(entities);
            }
            if (!this.cachedGlowingEntities.isEmpty()) {
                for (Entity entity : this.cachedGlowingEntities) {
                    if (!entity.m_6084_() || entity.m_20275_(player.m_20185_(), player.m_20186_(), player.m_20189_()) > range * range) {
                        entity.m_146915_(false);
                        this.cachedGlowingEntities.remove(entity);
                        continue;
                    }
                    entity.m_146915_(true);
                }
            }
            return;
        }
        if (!this.cachedGlowingEntities.isEmpty()) {
            for (Entity entity : this.cachedGlowingEntities) {
                if (!entity.m_6084_()) continue;
                entity.m_146915_(false);
            }
            this.cachedGlowingEntities.clear();
        }
    }

    @Override
    public boolean displaySpectralMobs() {
        return this.displayMobs;
    }
}

