/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.items;

import de.ellpeck.actuallyadditions.api.ActuallyAdditionsAPI;
import de.ellpeck.actuallyadditions.api.recipe.CoffeeIngredient;
import de.ellpeck.actuallyadditions.mod.crafting.CoffeeIngredientRecipe;
import de.ellpeck.actuallyadditions.mod.items.ActuallyItems;
import de.ellpeck.actuallyadditions.mod.items.base.ItemBase;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.StringUtil;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemCoffee
extends ItemBase {
    private static final FoodProperties FOOD = new FoodProperties.Builder().m_38760_(8).m_38758_(5.0f).m_38765_().m_38767_();

    public ItemCoffee() {
        super(ActuallyItems.defaultProps().m_41489_(FOOD).m_41503_(3));
    }

    @Nullable
    public static CoffeeIngredientRecipe getIngredientRecipeFromStack(ItemStack stack) {
        for (CoffeeIngredientRecipe recipeHolder : ActuallyAdditionsAPI.COFFEE_MACHINE_INGREDIENTS) {
            if (!recipeHolder.getIngredient().test(stack)) continue;
            return recipeHolder;
        }
        return null;
    }

    public static void applyPotionEffectsFromStack(ItemStack stack, LivingEntity player) {
        MobEffectInstance[] effects = ActuallyAdditionsAPI.methodHandler.getEffectsFromStack(stack);
        if (effects != null && effects.length > 0) {
            for (MobEffectInstance effect : effects) {
                player.m_7292_(new MobEffectInstance(effect.m_19544_(), effect.m_19557_() * 20, effect.m_19564_()));
            }
        }
    }

    public ItemStack m_5922_(ItemStack stack, Level level, LivingEntity livingEntity) {
        ItemStack theStack = stack.m_41777_();
        super.m_5922_(stack, level, livingEntity);
        ItemCoffee.applyPotionEffectsFromStack(stack, livingEntity);
        theStack.m_41721_(theStack.m_41773_() + 1);
        if (theStack.m_41776_() - theStack.m_41773_() < 0) {
            return new ItemStack((ItemLike)ActuallyItems.EMPTY_CUP.get());
        }
        return theStack;
    }

    public UseAnim m_6164_(ItemStack pStack) {
        return UseAnim.DRINK;
    }

    @Nullable
    public CompoundTag getShareTag(ItemStack stack) {
        return super.getShareTag(stack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level playerIn, List<Component> tooltip, TooltipFlag advanced) {
        MobEffectInstance[] effects = ActuallyAdditionsAPI.methodHandler.getEffectsFromStack(stack);
        if (effects != null) {
            for (MobEffectInstance effect : effects) {
                tooltip.add((Component)Component.m_237115_((String)effect.m_19576_()).m_130946_(" " + (effect.m_19564_() + 1) + ", " + StringUtil.m_14404_((int)(effect.m_19557_() * 20))).m_130940_(ChatFormatting.GRAY));
            }
        } else {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.actuallyadditions.coffeeCup.noEffect").m_130940_(ChatFormatting.GRAY));
        }
    }

    public boolean m_8120_(ItemStack stack) {
        return false;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return false;
    }

    public static class MilkIngredient
    extends CoffeeIngredient {
        public MilkIngredient(Ingredient ingredient) {
            super(ingredient, 0, new MobEffectInstance[0]);
        }

        @Override
        public boolean effect(ItemStack stack) {
            if (this.effects == null || this.effects.length > 0) {
                // empty if block
            }
            this.effects = null;
            return true;
        }

        @Override
        public String getExtraText() {
            return I18n.m_118938_((String)"jei.actuallyadditions.coffee.extra.milk", (Object[])new Object[0]);
        }
    }
}

