/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.items;

import de.ellpeck.actuallyadditions.mod.items.base.ItemEnergy;
import de.ellpeck.actuallyadditions.mod.util.ItemUtil;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;

public class ItemBattery
extends ItemEnergy {
    public ItemBattery(int capacity, int transfer) {
        super(capacity, transfer);
    }

    @Override
    public boolean m_5812_(ItemStack stack) {
        return ItemUtil.isEnabled(stack);
    }

    public void m_6883_(@Nonnull ItemStack stack, Level world, @Nonnull Entity entity, int itemSlot, boolean isSelected) {
        if (!world.f_46443_ && entity instanceof Player) {
            Player player = (Player)entity;
            if (ItemUtil.isEnabled(stack) && !isSelected) {
                for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
                    ItemStack slot = player.m_150109_().m_8020_(i);
                    if (slot.m_41619_() || slot.m_41613_() != 1) continue;
                    LazyOptional energy = slot.getCapability(ForgeCapabilities.ENERGY);
                    energy.ifPresent(cap -> {
                        int extractable = this.extractEnergy(stack, Integer.MAX_VALUE, true);
                        int received = cap.receiveEnergy(extractable, false);
                        if (received > 0) {
                            this.extractEnergy(stack, received, false);
                        }
                    });
                }
            }
        }
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, @Nonnull Player player, @Nonnull InteractionHand hand) {
        if (!worldIn.f_46443_ && player.m_6144_()) {
            ItemUtil.changeEnabled(player, hand);
            return InteractionResultHolder.m_19090_((Object)player.m_21120_(hand));
        }
        return super.m_7203_(worldIn, player, hand);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level playerIn, List<Component> list, TooltipFlag advanced) {
        super.m_7373_(stack, playerIn, list, advanced);
        list.add((Component)Component.m_237115_((String)("tooltip.actuallyadditions.battery." + (ItemUtil.isEnabled(stack) ? "discharge" : "noDischarge"))));
        list.add((Component)Component.m_237115_((String)"tooltip.actuallyadditions.battery.changeMode"));
    }
}

