/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.items;

import de.ellpeck.actuallyadditions.mod.items.ItemPhantomConnector;
import de.ellpeck.actuallyadditions.mod.items.base.ItemEnergy;
import de.ellpeck.actuallyadditions.mod.util.StackUtil;
import de.ellpeck.actuallyadditions.mod.util.Util;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class Filler
extends ItemEnergy {
    public Filler() {
        super(500000, 1000);
    }

    private static boolean removeFittingItem(BlockState state, Player player) {
        Block block = state.m_60734_();
        ItemStack stack = new ItemStack((ItemLike)block, 1);
        if (StackUtil.isValid(stack)) {
            for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
                ItemStack slot = player.m_150109_().m_8020_(i);
                if (!StackUtil.isValid(slot) || !ItemStack.m_41656_((ItemStack)slot, (ItemStack)stack)) continue;
                slot.m_41774_(1);
                if (!StackUtil.isValid(slot)) {
                    player.m_150109_().m_6836_(i, ItemStack.f_41583_);
                }
                return true;
            }
        }
        return false;
    }

    private static void saveData(BlockState state, ItemStack wand) {
        wand.m_41784_().m_128365_("state", (Tag)NbtUtils.m_129202_((BlockState)state));
    }

    private static Optional<BlockState> loadData(ItemStack stack) {
        if (stack.m_41784_().m_128441_("state")) {
            return Optional.of(NbtUtils.m_247651_((HolderGetter)BuiltInRegistries.f_256975_.m_255303_(), (CompoundTag)stack.m_41784_().m_128469_("state")));
        }
        return Optional.empty();
    }

    public InteractionResult m_6225_(UseOnContext context) {
        if (context.m_43723_() == null) {
            return InteractionResult.PASS;
        }
        ItemStack stack = context.m_43723_().m_21120_(context.m_43724_());
        if (!context.m_43725_().f_46443_ && context.m_43723_().m_21212_() <= 0) {
            CompoundTag compound;
            if (context.m_43723_().m_6047_()) {
                BlockState state = context.m_43725_().m_8055_(context.m_8083_());
                Filler.saveData(state, stack);
                return InteractionResult.SUCCESS;
            }
            if (Filler.loadData(stack).isPresent() && (compound = stack.m_41784_()).m_128451_("CurrX") == 0 && compound.m_128451_("CurrY") == 0 && compound.m_128451_("CurrZ") == 0) {
                compound.m_128405_("FirstX", context.m_8083_().m_123341_());
                compound.m_128405_("FirstY", context.m_8083_().m_123342_());
                compound.m_128405_("FirstZ", context.m_8083_().m_123343_());
                context.m_43723_().m_6672_(context.m_43724_());
                return InteractionResult.SUCCESS;
            }
        }
        return super.m_6225_(context);
    }

    public void m_5551_(ItemStack stack, Level world, LivingEntity entity, int timeLeft) {
        if (!world.f_46443_) {
            Player player;
            HitResult result;
            boolean clear = true;
            if (entity instanceof Player && (result = (player = (Player)entity).m_19907_(Util.getReachDistance(player), 1.0f, false)) instanceof BlockHitResult) {
                CompoundTag compound = stack.m_41784_();
                BlockPos pos = ((BlockHitResult)result).m_82425_();
                compound.m_128405_("SecondX", pos.m_123341_());
                compound.m_128405_("SecondY", pos.m_123342_());
                compound.m_128405_("SecondZ", pos.m_123343_());
                clear = false;
            }
            if (clear) {
                ItemPhantomConnector.clearStorage(stack, "FirstX", "FirstY", "FirstZ");
            }
        }
        super.m_5551_(stack, world, entity, timeLeft);
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int itemSlot, boolean isSelected) {
        super.m_6883_(stack, world, entity, itemSlot, isSelected);
        if (!world.f_46443_) {
            boolean shouldClear = false;
            if (isSelected) {
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    if (stack.m_41782_()) {
                        boolean creative = player.m_7500_();
                        CompoundTag compound = stack.m_41784_();
                        BlockPos firstPos = new BlockPos(compound.m_128451_("FirstX"), compound.m_128451_("FirstY"), compound.m_128451_("FirstZ"));
                        BlockPos secondPos = new BlockPos(compound.m_128451_("SecondX"), compound.m_128451_("SecondY"), compound.m_128451_("SecondZ"));
                        if (!BlockPos.f_121853_.equals((Object)firstPos) && !BlockPos.f_121853_.equals((Object)secondPos)) {
                            int energyUse = 1500;
                            Optional<BlockState> data = Filler.loadData(stack);
                            if (data.isPresent() && (creative || this.getEnergyStored(stack) >= energyUse)) {
                                int currZ;
                                int currY;
                                BlockState replaceState = data.get();
                                int lowestX = Math.min(firstPos.m_123341_(), secondPos.m_123341_());
                                int lowestY = Math.min(firstPos.m_123342_(), secondPos.m_123342_());
                                int lowestZ = Math.min(firstPos.m_123343_(), secondPos.m_123343_());
                                int currX = compound.m_128451_("CurrX");
                                BlockPos pos = new BlockPos(lowestX + currX, lowestY + (currY = compound.m_128451_("CurrY")), lowestZ + (currZ = compound.m_128451_("CurrZ")));
                                BlockState state = world.m_8055_(pos);
                                if (state.m_247087_() && replaceState.m_60710_((LevelReader)world, pos)) {
                                    if (creative || Filler.removeFittingItem(replaceState, player)) {
                                        world.m_7731_(pos, replaceState, 2);
                                        SoundType sound = replaceState.m_60734_().getSoundType(replaceState, (LevelReader)world, pos, (Entity)player);
                                        world.m_5594_(null, pos, sound.m_56777_(), SoundSource.BLOCKS, sound.m_56773_() / 2.0f + 0.5f, sound.m_56774_() * 0.8f);
                                        if (!creative) {
                                            this.extractEnergyInternal(stack, energyUse, false);
                                        }
                                    } else {
                                        shouldClear = true;
                                    }
                                }
                                int distX = Math.abs(secondPos.m_123341_() - firstPos.m_123341_());
                                int distY = Math.abs(secondPos.m_123342_() - firstPos.m_123342_());
                                int distZ = Math.abs(secondPos.m_123343_() - firstPos.m_123343_());
                                if (++currX > distX) {
                                    currX = 0;
                                    if (++currY > distY) {
                                        currY = 0;
                                        if (++currZ > distZ) {
                                            shouldClear = true;
                                        }
                                    }
                                }
                                if (!shouldClear) {
                                    compound.m_128405_("CurrX", currX);
                                    compound.m_128405_("CurrY", currY);
                                    compound.m_128405_("CurrZ", currZ);
                                }
                            } else {
                                shouldClear = true;
                            }
                        }
                    }
                }
            } else {
                shouldClear = true;
            }
            if (shouldClear) {
                ItemPhantomConnector.clearStorage(stack, "FirstX", "FirstY", "FirstZ", "SecondX", "SecondY", "SecondZ", "CurrX", "CurrY", "CurrZ");
            }
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        MutableComponent display = Filler.loadData(stack).map(state -> state.m_60734_().m_49954_()).orElse(Component.m_237115_((String)"tooltip.actuallyadditions.item_filling_wand.selected_block.none"));
        tooltip.add((Component)Component.m_237110_((String)"tooltip.actuallyadditions.item_filling_wand.selected_block", (Object[])new Object[]{display.getString()}));
    }

    public int m_8105_(ItemStack stack) {
        return Integer.MAX_VALUE;
    }
}

