/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.items;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import de.ellpeck.actuallyadditions.api.ActuallyTags;
import de.ellpeck.actuallyadditions.mod.config.CommonConfig;
import de.ellpeck.actuallyadditions.mod.inventory.ContainerDrill;
import de.ellpeck.actuallyadditions.mod.items.ActuallyItems;
import de.ellpeck.actuallyadditions.mod.items.ItemDrillUpgrade;
import de.ellpeck.actuallyadditions.mod.items.base.ItemEnergy;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityInventoryBase;
import de.ellpeck.actuallyadditions.mod.util.ItemStackHandlerAA;
import de.ellpeck.actuallyadditions.mod.util.ItemUtil;
import de.ellpeck.actuallyadditions.mod.util.Util;
import de.ellpeck.actuallyadditions.mod.util.WorldUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.TierSortingRegistry;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.registries.ForgeRegistries;

public class DrillItem
extends ItemEnergy {
    public static final int HARVEST_LEVEL = 4;
    private static final int ENERGY_USE = 100;
    private static final List<ToolAction> ACTIONS = List.of(ToolActions.SHOVEL_DIG, ToolActions.PICKAXE_DIG);
    private final Multimap<Attribute, AttributeModifier> attributes_unpowered = ArrayListMultimap.create();
    private final Multimap<Attribute, AttributeModifier> attributes_powered = ArrayListMultimap.create();

    public DrillItem() {
        super(ActuallyItems.defaultProps().m_41499_(0).m_41487_(1), 250000, 1000);
        this.attributes_powered.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Drill Modifier", 8.0, AttributeModifier.Operation.ADDITION));
        this.attributes_powered.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Tool Modifier", 1.5, AttributeModifier.Operation.ADDITION));
        this.attributes_unpowered.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Drill Modifier", (double)0.1f, AttributeModifier.Operation.ADDITION));
        this.attributes_unpowered.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Tool Modifier", 1.5, AttributeModifier.Operation.ADDITION));
    }

    public boolean canPerformAction(@Nonnull ItemStack stack, @Nonnull ToolAction toolAction) {
        return ACTIONS.contains(toolAction);
    }

    public boolean m_8096_(@Nonnull BlockState pBlock) {
        Tiers tier = Tiers.NETHERITE;
        if (TierSortingRegistry.isTierSorted((Tier)tier)) {
            return TierSortingRegistry.isCorrectTierForDrops((Tier)tier, (BlockState)pBlock) && pBlock.m_204336_(ActuallyTags.Blocks.MINEABLE_WITH_DRILL);
        }
        return pBlock.m_204336_(ActuallyTags.Blocks.MINEABLE_WITH_DRILL);
    }

    public static void loadSlotsFromNBT(IItemHandlerModifiable slots, ItemStack stack) {
        CompoundTag compound = stack.m_41784_();
        TileEntityInventoryBase.loadSlots(slots, compound);
    }

    public static void writeSlotsToNBT(IItemHandler slots, ItemStack stack) {
        CompoundTag compound = stack.m_41784_();
        TileEntityInventoryBase.saveSlots(slots, compound);
        stack.m_41751_(compound);
    }

    @Nonnull
    public InteractionResult m_6225_(UseOnContext context) {
        ItemStack equip;
        int slot;
        InteractionHand hand;
        Level level = context.m_43725_();
        Player player = context.m_43723_();
        ItemStack stack = player.m_21120_(hand = context.m_43724_());
        ItemStack upgrade = this.getHasUpgradeAsStack(stack, ItemDrillUpgrade.UpgradeType.PLACER);
        if (!upgrade.m_41619_() && (slot = ItemDrillUpgrade.getSlotToPlaceFrom(upgrade)) >= 0 && slot < 9 && !(equip = player.m_150109_().m_8020_(slot)).m_41619_() && equip != stack) {
            ItemStack toPlaceStack = equip;
            BlockHitResult result = new BlockHitResult(context.m_43720_(), context.m_43719_(), context.m_8083_(), context.m_43721_());
            return toPlaceStack.m_41661_(new UseOnContext(level, player, hand, toPlaceStack, result));
        }
        return super.m_6225_(context);
    }

    public ItemStack getHasUpgradeAsStack(ItemStack stack, ItemDrillUpgrade.UpgradeType upgrade) {
        ItemStackHandlerAA inv = new ItemStackHandlerAA(5);
        DrillItem.loadSlotsFromNBT((IItemHandlerModifiable)inv, stack);
        for (int i = 0; i < inv.getSlots(); ++i) {
            Item item;
            ItemStack slotStack = inv.getStackInSlot(i);
            if (slotStack.m_41619_() || !((item = slotStack.m_41720_()) instanceof ItemDrillUpgrade)) continue;
            ItemDrillUpgrade drillUpgrade = (ItemDrillUpgrade)item;
            if (drillUpgrade.type != upgrade) continue;
            return slotStack;
        }
        return ItemStack.f_41583_;
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(Level world, @Nonnull Player player, @Nonnull InteractionHand hand) {
        if (!world.f_46443_ && player.m_6144_() && hand == InteractionHand.MAIN_HAND) {
            player.m_5893_((MenuProvider)new SimpleMenuProvider((id, inv, p) -> new ContainerDrill(id, inv), (Component)Component.m_237115_((String)"container.actuallyadditions.drill")));
        }
        return new InteractionResultHolder(InteractionResult.PASS, (Object)player.m_21120_(hand));
    }

    @Nonnull
    public InteractionResult m_6880_(@Nonnull ItemStack stack, @Nonnull Player player, @Nonnull LivingEntity entityHit, @Nonnull InteractionHand hand) {
        int use = this.getEnergyUsePerBlock(stack);
        if (!(entityHit instanceof Player && ((Player)entityHit).m_7500_() || this.getEnergyStored(stack) < use)) {
            this.extractEnergyInternal(stack, use, false);
        }
        return InteractionResult.SUCCESS;
    }

    @Nonnull
    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, @Nonnull ItemStack stack) {
        if (slot == EquipmentSlot.MAINHAND) {
            return this.getEnergyStored(stack) >= 100 ? this.attributes_powered : this.attributes_unpowered;
        }
        return ImmutableMultimap.of();
    }

    public float m_8102_(@Nonnull ItemStack stack, @Nonnull BlockState state) {
        return this.getEnergyStored(stack) >= this.getEnergyUsePerBlock(stack) ? (this.hasExtraWhitelist(state.m_60734_()) || state.m_204336_(ActuallyTags.Blocks.MINEABLE_WITH_DRILL) ? this.getEfficiencyFromUpgrade(stack) : 1.0f) : 0.1f;
    }

    public boolean onBlockStartBreak(@Nonnull ItemStack stack, @Nonnull BlockPos pos, @Nonnull Player player) {
        boolean toReturn = false;
        int use = this.getEnergyUsePerBlock(stack);
        if (this.getEnergyStored(stack) >= use) {
            if (this.getHasUpgrade(stack, ItemDrillUpgrade.UpgradeType.SILK_TOUCH)) {
                ItemUtil.addEnchantment(stack, Enchantments.f_44985_, 1);
            } else if (this.getHasUpgrade(stack, ItemDrillUpgrade.UpgradeType.FORTUNE)) {
                ItemUtil.addEnchantment(stack, Enchantments.f_44987_, this.getHasUpgrade(stack, ItemDrillUpgrade.UpgradeType.FORTUNE_II) ? 3 : 1);
            }
            HitResult ray = player.m_19907_(Util.getReachDistance(player), 1.0f, false);
            if (ray instanceof BlockHitResult) {
                BlockHitResult trace = (BlockHitResult)ray;
                toReturn = !player.m_6144_() && this.getHasUpgrade(stack, ItemDrillUpgrade.UpgradeType.THREE_BY_THREE) ? (this.getHasUpgrade(stack, ItemDrillUpgrade.UpgradeType.FIVE_BY_FIVE) ? this.breakBlocks(stack, 2, player.m_9236_(), pos, trace.m_82434_(), player) : this.breakBlocks(stack, 1, player.m_9236_(), pos, trace.m_82434_(), player)) : this.breakBlocks(stack, 0, player.m_9236_(), pos, trace.m_82434_(), player);
                ItemUtil.removeEnchantment(stack, Enchantments.f_44985_);
                ItemUtil.removeEnchantment(stack, Enchantments.f_44987_);
            }
        }
        return toReturn;
    }

    public boolean isCorrectToolForDrops(ItemStack stack, BlockState state) {
        return this.getEnergyStored(stack) >= this.getEnergyUsePerBlock(stack) && super.isCorrectToolForDrops(stack, state);
    }

    public int getEnergyUsePerBlock(ItemStack stack) {
        int use = 100;
        if (this.getHasUpgrade(stack, ItemDrillUpgrade.UpgradeType.SPEED)) {
            use += 50;
            if (this.getHasUpgrade(stack, ItemDrillUpgrade.UpgradeType.SPEED_II)) {
                use += 75;
                if (this.getHasUpgrade(stack, ItemDrillUpgrade.UpgradeType.SPEED_III)) {
                    use += 175;
                }
            }
        }
        if (this.getHasUpgrade(stack, ItemDrillUpgrade.UpgradeType.SILK_TOUCH)) {
            use += 100;
        }
        if (this.getHasUpgrade(stack, ItemDrillUpgrade.UpgradeType.FORTUNE)) {
            use += 40;
            if (this.getHasUpgrade(stack, ItemDrillUpgrade.UpgradeType.FORTUNE_II)) {
                use += 80;
            }
        }
        if (this.getHasUpgrade(stack, ItemDrillUpgrade.UpgradeType.THREE_BY_THREE)) {
            use += 10;
            if (this.getHasUpgrade(stack, ItemDrillUpgrade.UpgradeType.FIVE_BY_FIVE)) {
                use += 30;
            }
        }
        return use;
    }

    public boolean getHasUpgrade(ItemStack stack, ItemDrillUpgrade.UpgradeType upgrade) {
        return !this.getHasUpgradeAsStack(stack, upgrade).m_41619_();
    }

    public float getEfficiencyFromUpgrade(ItemStack stack) {
        float efficiency = 8.0f;
        if (this.getHasUpgrade(stack, ItemDrillUpgrade.UpgradeType.SPEED)) {
            efficiency = this.getHasUpgrade(stack, ItemDrillUpgrade.UpgradeType.SPEED_II) ? (this.getHasUpgrade(stack, ItemDrillUpgrade.UpgradeType.SPEED_III) ? (efficiency += 37.0f) : (efficiency += 25.0f)) : (efficiency += 8.0f);
        }
        if (this.getHasUpgrade(stack, ItemDrillUpgrade.UpgradeType.THREE_BY_THREE)) {
            efficiency *= 0.5f;
            if (this.getHasUpgrade(stack, ItemDrillUpgrade.UpgradeType.FIVE_BY_FIVE)) {
                efficiency *= 0.35f;
            }
        }
        return efficiency;
    }

    public boolean breakBlocks(ItemStack stack, int radius, Level world, BlockPos aPos, Direction side, Player player) {
        BlockState theState;
        int xRange = radius;
        int yRange = radius;
        int zRange = 0;
        if (side.m_122434_() == Direction.Axis.Y) {
            zRange = radius;
            yRange = 0;
        }
        if (side.m_122434_() == Direction.Axis.X) {
            xRange = 0;
            zRange = radius;
        }
        BlockState state = world.m_8055_(aPos);
        float mainHardness = state.m_60800_((BlockGetter)world, aPos);
        int use = this.getEnergyUsePerBlock(stack);
        if (this.getEnergyStored(stack) >= use) {
            if (!this.tryHarvestBlock(world, aPos, false, stack, player, use)) {
                return false;
            }
        } else {
            return false;
        }
        if (radius == 2 && side.m_122434_() != Direction.Axis.Y && (theState = world.m_8055_(aPos = aPos.m_7494_())).m_60800_((BlockGetter)world, aPos) <= mainHardness + 5.0f) {
            this.tryHarvestBlock(world, aPos, true, stack, player, use);
        }
        if (radius > 0 && mainHardness >= 0.2f) {
            for (int xPos = aPos.m_123341_() - xRange; xPos <= aPos.m_123341_() + xRange; ++xPos) {
                for (int yPos = aPos.m_123342_() - yRange; yPos <= aPos.m_123342_() + yRange; ++yPos) {
                    for (int zPos = aPos.m_123343_() - zRange; zPos <= aPos.m_123343_() + zRange; ++zPos) {
                        if (aPos.m_123341_() == xPos && aPos.m_123342_() == yPos && aPos.m_123343_() == zPos) continue;
                        if (this.getEnergyStored(stack) >= use) {
                            BlockPos thePos = new BlockPos(xPos, yPos, zPos);
                            BlockState theState2 = world.m_8055_(thePos);
                            if (!(theState2.m_60800_((BlockGetter)world, thePos) <= mainHardness + 5.0f)) continue;
                            this.tryHarvestBlock(world, thePos, true, stack, player, use);
                            continue;
                        }
                        return false;
                    }
                }
            }
        }
        return true;
    }

    public List<BlockPos> gatherBreakingPositions(ItemStack stack, int radius, Level world, BlockPos aPos, Direction side, Player player) {
        BlockState theState;
        int energyStored = this.getEnergyStored(stack);
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        int xRange = radius;
        int yRange = radius;
        int zRange = 0;
        if (side.m_122434_() == Direction.Axis.Y) {
            zRange = radius;
            yRange = 0;
        }
        if (side.m_122434_() == Direction.Axis.X) {
            xRange = 0;
            zRange = radius;
        }
        BlockState state = world.m_8055_(aPos);
        float mainHardness = state.m_60800_((BlockGetter)world, aPos);
        int use = this.getEnergyUsePerBlock(stack);
        if (energyStored < use) {
            return positions;
        }
        if (radius == 2 && side.m_122434_() != Direction.Axis.Y && (theState = world.m_8055_(aPos = aPos.m_7494_())).m_60800_((BlockGetter)world, aPos) <= mainHardness + 5.0f) {
            positions.add(aPos.m_7949_());
        }
        if (radius > 0 && mainHardness >= 0.2f) {
            for (int xPos = aPos.m_123341_() - xRange; xPos <= aPos.m_123341_() + xRange; ++xPos) {
                for (int yPos = aPos.m_123342_() - yRange; yPos <= aPos.m_123342_() + yRange; ++yPos) {
                    for (int zPos = aPos.m_123343_() - zRange; zPos <= aPos.m_123343_() + zRange; ++zPos) {
                        if (aPos.m_123341_() == xPos && aPos.m_123342_() == yPos && aPos.m_123343_() == zPos) continue;
                        if (energyStored >= use) {
                            BlockPos thePos = new BlockPos(xPos, yPos, zPos);
                            BlockState theState2 = world.m_8055_(thePos);
                            if (!(theState2.m_60800_((BlockGetter)world, thePos) <= mainHardness + 5.0f)) continue;
                            energyStored -= use;
                            positions.add(thePos.m_7949_());
                            continue;
                        }
                        return positions;
                    }
                }
            }
        }
        return positions;
    }

    private boolean tryHarvestBlock(Level world, BlockPos pos, boolean isExtra, ItemStack stack, Player player, int use) {
        boolean canHarvest;
        BlockState state = world.m_8055_(pos);
        Block block = state.m_60734_();
        float hardness = state.m_60800_((BlockGetter)world, pos);
        boolean bl = canHarvest = !(!ForgeHooks.isCorrectToolForDrops((BlockState)state, (Player)player) && !this.isCorrectToolForDrops(stack, state) || isExtra && !(this.m_8102_(stack, world.m_8055_(pos)) > 1.0f));
        if (hardness >= 0.0f && (!isExtra || canHarvest && !state.m_155947_())) {
            if (!player.m_7500_()) {
                this.extractEnergyInternal(stack, use, false);
            }
            return WorldUtil.breakExtraBlock(stack, world, player, pos);
        }
        return false;
    }

    private boolean hasExtraWhitelist(Block block) {
        String name;
        ResourceLocation location;
        if (block != null && (location = ForgeRegistries.BLOCKS.getKey((Object)block)) != null && (name = location.toString()) != null) {
            for (String s : (List)CommonConfig.ItemSettings.DRILL_EXTRA_MINING_WHITELIST.get()) {
                if (s == null || !s.equals(name)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean shouldCauseBlockBreakReset(@Nonnull ItemStack oldStack, @Nonnull ItemStack newStack) {
        return !ItemStack.m_41656_((ItemStack)newStack, (ItemStack)oldStack);
    }
}

