/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.inventory.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import de.ellpeck.actuallyadditions.mod.inventory.ContainerOilGenerator;
import de.ellpeck.actuallyadditions.mod.inventory.gui.AAScreen;
import de.ellpeck.actuallyadditions.mod.inventory.gui.EnergyDisplay;
import de.ellpeck.actuallyadditions.mod.inventory.gui.FluidDisplay;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityOilGenerator;
import de.ellpeck.actuallyadditions.mod.util.AssetUtil;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.IFluidTank;

@OnlyIn(value=Dist.CLIENT)
public class GuiOilGenerator
extends AAScreen<ContainerOilGenerator> {
    private static final ResourceLocation RES_LOC = AssetUtil.getGuiLocation("gui_oil_generator");
    private final TileEntityOilGenerator generator;
    private EnergyDisplay energy;
    private FluidDisplay fluid;

    public GuiOilGenerator(ContainerOilGenerator container, Inventory inventory, Component title) {
        super(container, inventory, title);
        this.generator = container.generator;
        this.f_97726_ = 176;
        this.f_97727_ = 179;
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.energy = new EnergyDisplay(this.f_97735_ + 42, this.f_97736_ + 5, this.generator.storage);
        this.fluid = new FluidDisplay(this.f_97735_ + 116, this.f_97736_ + 5, (IFluidTank)this.generator.tank);
    }

    @Override
    public void m_88315_(@Nonnull GuiGraphics guiGraphics, int x, int y, float f) {
        super.m_88315_(guiGraphics, x, y, f);
        this.energy.render(guiGraphics, x, y);
        this.fluid.render(guiGraphics, x, y);
    }

    public void m_7286_(GuiGraphics guiGraphics, float f, int x, int y) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.m_280218_(AssetUtil.GUI_INVENTORY_LOCATION, this.f_97735_, this.f_97736_ + 93, 0, 0, 176, 86);
        guiGraphics.m_280218_(RES_LOC, this.f_97735_, this.f_97736_, 0, 0, 176, 93);
        if (this.generator.currentBurnTime > 0 && this.generator.maxBurnTime > 0) {
            int i = this.generator.getBurningScaled(13);
            guiGraphics.m_280218_(RES_LOC, this.f_97735_ + 72, this.f_97736_ + 44 + 12 - i, 176, 96 - i, 14, i);
        }
        if (this.generator.maxBurnTime > 0 && this.generator.currentEnergyProduce > 0) {
            guiGraphics.m_280653_(this.f_96547_, (Component)Component.m_237113_((String)(this.generator.currentEnergyProduce + " ")).m_7220_((Component)Component.m_237115_((String)"misc.actuallyadditions.energy_tick")), this.f_97735_ + 87, this.f_97736_ + 65, 0xFFFFFF);
            guiGraphics.m_280137_(this.f_96547_, "for " + this.generator.maxBurnTime + " t", this.f_97735_ + 87, this.f_97736_ + 75, 0xFFFFFF);
            PoseStack poseStack = guiGraphics.m_280168_();
            poseStack.m_85836_();
            poseStack.m_252880_((float)(this.f_97735_ + 87), (float)(this.f_97736_ + 85), 0.0f);
            poseStack.m_85841_(0.5625f, 0.5625f, 1.0f);
            int usage = this.generator.fuelUsage;
            guiGraphics.m_280137_(this.f_96547_, "(per " + usage + " mB)", 0, 0, 0xFFFFFF);
            poseStack.m_85849_();
        }
        this.energy.draw(guiGraphics);
        this.fluid.draw(guiGraphics);
    }
}

