/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.inventory.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import de.ellpeck.actuallyadditions.mod.inventory.ContainerFurnaceDouble;
import de.ellpeck.actuallyadditions.mod.inventory.gui.AAScreen;
import de.ellpeck.actuallyadditions.mod.inventory.gui.EnergyDisplay;
import de.ellpeck.actuallyadditions.mod.network.PacketHandlerHelper;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityPoweredFurnace;
import de.ellpeck.actuallyadditions.mod.util.AssetUtil;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class GuiFurnaceDouble
extends AAScreen<ContainerFurnaceDouble> {
    private static final ResourceLocation RES_LOC = AssetUtil.getGuiLocation("gui_furnace_double");
    private final TileEntityPoweredFurnace tileFurnace;
    private EnergyDisplay energy;
    private Button buttonAutoSplit;

    public GuiFurnaceDouble(ContainerFurnaceDouble container, Inventory inventory, Component title) {
        super(container, inventory, title);
        this.tileFurnace = container.furnace;
        this.f_97726_ = 176;
        this.f_97727_ = 179;
    }

    @Override
    public void m_88315_(@Nonnull GuiGraphics guiGraphics, int x, int y, float f) {
        super.m_88315_(guiGraphics, x, y, f);
        this.energy.render(guiGraphics, x, y);
        if (this.buttonAutoSplit.m_5953_((double)x, (double)y)) {
            guiGraphics.m_280557_(this.f_96547_, (Component)Component.m_237115_((String)("info.actuallyadditions.gui.autosplititems." + (this.tileFurnace.isAutoSplit ? "on" : "off"))), x, y);
        }
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.energy = new EnergyDisplay(this.f_97735_ + 27, this.f_97736_ + 5, this.tileFurnace.storage);
        this.buttonAutoSplit = Button.m_253074_((Component)Component.m_237113_((String)"S"), button -> PacketHandlerHelper.sendButtonPacket(this.tileFurnace, 0)).m_252987_(this.getGuiLeft(), this.f_97736_ + 5, 16, 16).m_253136_();
        this.buttonAutoSplit.setFGColor((this.tileFurnace.isAutoSplit ? ChatFormatting.DARK_GREEN.m_126665_() : ChatFormatting.RED.m_126665_()).intValue());
        this.m_142416_((GuiEventListener)this.buttonAutoSplit);
    }

    public void m_181908_() {
        super.m_181908_();
        this.buttonAutoSplit.setFGColor((this.tileFurnace.isAutoSplit ? ChatFormatting.DARK_GREEN.m_126665_() : ChatFormatting.RED.m_126665_()).intValue());
    }

    public void m_7286_(@Nonnull GuiGraphics guiGraphics, float f, int x, int y) {
        int i;
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.m_280218_(AssetUtil.GUI_INVENTORY_LOCATION, this.f_97735_, this.f_97736_ + 93, 0, 0, 176, 86);
        guiGraphics.m_280218_(RES_LOC, this.f_97735_, this.f_97736_, 0, 0, 176, 93);
        if (this.tileFurnace.firstSmeltTime > 0) {
            i = this.tileFurnace.getFirstTimeToScale(23);
            guiGraphics.m_280218_(RES_LOC, this.f_97735_ + 51, this.f_97736_ + 40, 176, 0, 24, i);
        }
        if (this.tileFurnace.secondSmeltTime > 0) {
            i = this.tileFurnace.getSecondTimeToScale(23);
            guiGraphics.m_280218_(RES_LOC, this.f_97735_ + 101, this.f_97736_ + 40, 176, 22, 24, i);
        }
        this.energy.draw(guiGraphics);
    }
}

