/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.inventory.gui;

import de.ellpeck.actuallyadditions.mod.inventory.ContainerFireworkBox;
import de.ellpeck.actuallyadditions.mod.network.PacketHandlerHelper;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityFireworkBox;
import de.ellpeck.actuallyadditions.mod.util.AssetUtil;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class GuiFireworkBox
extends AbstractContainerScreen<ContainerFireworkBox> {
    private static final ResourceLocation RES_LOC = AssetUtil.getGuiLocation("gui_firework_box");
    protected final TileEntityFireworkBox tile;

    public GuiFireworkBox(ContainerFireworkBox screenContainer, Inventory inv, Component titleIn) {
        super((AbstractContainerMenu)screenContainer, inv, titleIn);
        this.tile = screenContainer.fireworkbox;
        this.f_97726_ = 302;
        this.f_97727_ = 130;
    }

    public void m_7856_() {
        super.m_7856_();
        DecimalFormat intFormatter = new DecimalFormat("0");
        int left = this.getGuiLeft() + 2;
        this.m_142416_((GuiEventListener)new CustomSlider(left, this.getGuiTop() + 2, (Component)Component.m_237113_((String)"Value Play"), 0.0, 5.0, this.tile.intValuePlay, intFormatter, slider -> PacketHandlerHelper.sendNumberPacket(this.tile, slider.getValue(), 0)));
        this.m_142416_((GuiEventListener)new CustomSlider(left, this.getGuiTop() + 23, (Component)Component.m_237113_((String)"Average Charge Amount"), 1.0, 4.0, this.tile.chargeAmount, intFormatter, slider -> PacketHandlerHelper.sendNumberPacket(this.tile, slider.getValue(), 1)));
        this.m_142416_((GuiEventListener)new CustomSlider(left, this.getGuiTop() + 44, (Component)Component.m_237113_((String)"Average Flight Time"), 1.0, 3.0, this.tile.flightTime, intFormatter, slider -> PacketHandlerHelper.sendNumberPacket(this.tile, slider.getValue(), 2)));
        this.m_142416_((GuiEventListener)new CustomSlider(left, this.getGuiTop() + 65, (Component)Component.m_237113_((String)"Effect Chance"), 0.0, 1.0, this.tile.trailOrFlickerChance, null, slider -> PacketHandlerHelper.sendNumberPacket(this.tile, slider.getValue(), 3)));
        this.m_142416_((GuiEventListener)new CustomSlider(left, this.getGuiTop() + 86, (Component)Component.m_237113_((String)"Flicker/Trail Ratio"), 0.0, 1.0, this.tile.flickerChance, null, slider -> PacketHandlerHelper.sendNumberPacket(this.tile, slider.getValue(), 4)));
        this.m_142416_((GuiEventListener)new CustomSlider(left, this.getGuiTop() + 107, (Component)Component.m_237113_((String)"Color Amount"), 1.0, 6.0, this.tile.colorAmount, intFormatter, slider -> PacketHandlerHelper.sendNumberPacket(this.tile, slider.getValue(), 5)));
        this.m_142416_((GuiEventListener)new CustomSlider(left + 150, this.getGuiTop() + 2, (Component)Component.m_237113_((String)"Small Ball"), 0.0, 1.0, this.tile.typeChance0, null, slider -> PacketHandlerHelper.sendNumberPacket(this.tile, slider.getValue(), 6)));
        this.m_142416_((GuiEventListener)new CustomSlider(left + 150, this.getGuiTop() + 23, (Component)Component.m_237113_((String)"Large Ball"), 0.0, 1.0, this.tile.typeChance1, null, slider -> PacketHandlerHelper.sendNumberPacket(this.tile, slider.getValue(), 7)));
        this.m_142416_((GuiEventListener)new CustomSlider(left + 150, this.getGuiTop() + 44, (Component)Component.m_237113_((String)"Star Shape"), 0.0, 1.0, this.tile.typeChance2, null, slider -> PacketHandlerHelper.sendNumberPacket(this.tile, slider.getValue(), 8)));
        this.m_142416_((GuiEventListener)new CustomSlider(left + 150, this.getGuiTop() + 65, (Component)Component.m_237113_((String)"Creeper Shape"), 0.0, 1.0, this.tile.typeChance3, null, slider -> PacketHandlerHelper.sendNumberPacket(this.tile, slider.getValue(), 9)));
        this.m_142416_((GuiEventListener)new CustomSlider(left + 150, this.getGuiTop() + 86, (Component)Component.m_237113_((String)"Burst"), 0.0, 1.0, this.tile.typeChance4, null, slider -> PacketHandlerHelper.sendNumberPacket(this.tile, slider.getValue(), 10)));
        this.m_142416_((GuiEventListener)new CustomSlider(left + 150, this.getGuiTop() + 107, (Component)Component.m_237113_((String)"Area of Effect"), 0.0, 4.0, this.tile.areaOfEffect, intFormatter, slider -> PacketHandlerHelper.sendNumberPacket(this.tile, slider.getValue(), 11)));
    }

    protected void m_280003_(GuiGraphics guiGraphics, int pMouseX, int pMouseY) {
        guiGraphics.m_280614_(this.f_96547_, this.f_96539_, (int)((float)this.getXSize() / 2.0f - (float)this.f_96547_.m_92852_((FormattedText)this.f_96539_) / 2.0f), -10, 0xFFFFFF, false);
    }

    protected void m_7286_(GuiGraphics guiGraphics, float partialTicks, int x, int y) {
        guiGraphics.m_280163_(RES_LOC, this.f_97735_, this.f_97736_, 0.0f, 0.0f, this.getXSize(), this.getYSize(), 512, 512);
    }

    public boolean m_7979_(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        if (this.m_7222_() != null && this.m_7282_() && pButton == 0) {
            return this.m_7222_().m_7979_(pMouseX, pMouseY, pButton, pDragX, pDragY);
        }
        return super.m_7979_(pMouseX, pMouseY, pButton, pDragX, pDragY);
    }

    private static class CustomSlider
    extends AbstractSliderButton {
        private final double min;
        private final double max;
        private final DecimalFormat format;
        private final Component sliderName;
        private final NumberFormat defaultFormat = new DecimalFormat("0.00000000");
        protected final OnApply onApply;
        private final double stepSize = 0.0;

        public CustomSlider(int x, int y, Component message, double min, double max, double defaultValue, DecimalFormat format, OnApply onApply) {
            super(x, y, 148, 20, message, defaultValue);
            this.sliderName = message;
            this.min = min;
            this.max = max;
            this.format = format;
            this.f_93577_ = (Mth.m_14008_((double)((float)this.f_93577_), (double)min, (double)max) - min) / (max - min);
            this.onApply = onApply;
            this.m_5695_();
        }

        protected void m_7212_(double mouseX, double mouseY, double dragX, double dragY) {
            super.m_7212_(mouseX, mouseY, dragX, dragY);
            this.m_93585_(mouseX);
        }

        private void m_93585_(double mouseX) {
            this.setSliderValue((mouseX - (double)(this.m_252754_() + 4)) / (double)(this.f_93618_ - 8));
        }

        public double getValue() {
            return this.f_93577_ * (this.max - this.min) + this.min;
        }

        private void setSliderValue(double value) {
            double oldValue = this.f_93577_;
            this.f_93577_ = this.snapToNearest(value);
            if (!Mth.m_14082_((double)oldValue, (double)this.f_93577_)) {
                this.m_5697_();
            }
            this.m_5695_();
        }

        private double snapToNearest(double value) {
            return Mth.m_14008_((double)value, (double)0.0, (double)1.0);
        }

        public String getValueString() {
            if (this.format == null) {
                if (this.getValue() == (double)((int)this.getValue())) {
                    return String.valueOf((double)((int)this.getValue()));
                }
                return this.defaultFormat.format(this.getValue());
            }
            return this.format.format(this.getValue());
        }

        protected void m_5695_() {
            this.m_93666_((Component)this.sliderName.m_6881_().m_130946_(": ").m_130946_(this.getValueString()));
        }

        public boolean m_6348_(double pMouseX, double pMouseY, int pButton) {
            return super.m_6348_(pMouseX, pMouseY, pButton);
        }

        protected void m_5697_() {
            this.onApply.onApply(this);
        }

        public static interface OnApply {
            public void onApply(CustomSlider var1);
        }
    }
}

