/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.inventory.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import de.ellpeck.actuallyadditions.mod.inventory.ContainerCoffeeMachine;
import de.ellpeck.actuallyadditions.mod.inventory.gui.AAScreen;
import de.ellpeck.actuallyadditions.mod.inventory.gui.EnergyDisplay;
import de.ellpeck.actuallyadditions.mod.inventory.gui.FluidDisplay;
import de.ellpeck.actuallyadditions.mod.network.PacketHandlerHelper;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityCoffeeMachine;
import de.ellpeck.actuallyadditions.mod.util.AssetUtil;
import java.util.Collections;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.IFluidTank;

@OnlyIn(value=Dist.CLIENT)
public class GuiCoffeeMachine
extends AAScreen<ContainerCoffeeMachine> {
    private static final ResourceLocation RES_LOC = AssetUtil.getGuiLocation("gui_coffee_machine");
    private final TileEntityCoffeeMachine machine;
    private EnergyDisplay energy;
    private FluidDisplay fluid;

    public GuiCoffeeMachine(ContainerCoffeeMachine container, Inventory inventory, Component title) {
        super(container, inventory, title);
        this.machine = container.machine;
        this.f_97726_ = 176;
        this.f_97727_ = 179;
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.m_142416_((GuiEventListener)new Button.Builder((Component)Component.m_237115_((String)"info.actuallyadditions.gui.ok"), b -> PacketHandlerHelper.sendButtonPacket(this.machine, 0)).m_252987_(this.f_97735_ + 60, this.f_97736_ + 11, 58, 20).m_253136_());
        this.energy = new EnergyDisplay(this.f_97735_ + 16, this.f_97736_ + 5, this.machine.storage);
        this.fluid = new FluidDisplay(this.f_97735_ - 30, this.f_97736_ + 1, (IFluidTank)this.machine.tank, true, false);
    }

    @Override
    public void m_88315_(@Nonnull GuiGraphics guiGraphics, int x, int y, float f) {
        super.m_88315_(guiGraphics, x, y, f);
        Minecraft mc = Minecraft.m_91087_();
        MutableComponent text = Component.m_237110_((String)"info.actuallyadditions.gui.coffee_amount", (Object[])new Object[]{this.machine.coffeeCacheAmount, 300});
        if (x >= this.f_97735_ + 40 && y >= this.f_97736_ + 25 && x <= this.f_97735_ + 49 && y <= this.f_97736_ + 56) {
            guiGraphics.m_280666_(this.f_96547_, Collections.singletonList(text), x, y);
        }
        this.energy.render(guiGraphics, x, y);
        this.fluid.render(guiGraphics, x, y);
    }

    public void m_7286_(@Nonnull GuiGraphics guiGraphics, float f, int x, int y) {
        int i;
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.m_280218_(AssetUtil.GUI_INVENTORY_LOCATION, this.f_97735_, this.f_97736_ + 93, 0, 0, 176, 86);
        guiGraphics.m_280218_(RES_LOC, this.f_97735_, this.f_97736_, 0, 0, 176, 93);
        if (this.machine.coffeeCacheAmount > 0) {
            i = this.machine.getCoffeeScaled(30);
            guiGraphics.m_280218_(RES_LOC, this.f_97735_ + 41, this.f_97736_ + 56 - i, 192, 0, 8, i);
        }
        if (this.machine.brewTime > 0) {
            i = this.machine.getBrewScaled(23);
            guiGraphics.m_280218_(RES_LOC, this.f_97735_ + 53, this.f_97736_ + 42, 192, 30, i, 16);
            int j = this.machine.getBrewScaled(26);
            guiGraphics.m_280218_(RES_LOC, this.f_97735_ + 99 + 25 - j, this.f_97736_ + 44, 217 - j, 46, j, 12);
        }
        this.energy.draw(guiGraphics);
        this.fluid.draw(guiGraphics);
    }
}

