/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.inventory.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import de.ellpeck.actuallyadditions.mod.util.AssetUtil;
import java.text.NumberFormat;
import java.util.Collections;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;

@OnlyIn(value=Dist.CLIENT)
public class FluidDisplay {
    private IFluidTank fluidReference;
    private Fluid oldFluid;
    private int x;
    private int y;
    private boolean outline;
    private TextureAtlasSprite sprite;
    private boolean drawTextNextTo;
    private boolean drawCapacityInTooltip = true;

    public FluidDisplay(int x, int y, IFluidTank fluidReference, boolean outline, boolean drawTextNextTo) {
        this.setData(x, y, fluidReference, outline, drawTextNextTo);
    }

    public FluidDisplay(int x, int y, IFluidTank fluidReference) {
        this(x, y, fluidReference, false, false);
    }

    public FluidDisplay(int x, int y, FluidStack stack, int capacity, boolean drawCapacity) {
        this.x = x;
        this.y = y;
        this.drawCapacityInTooltip = drawCapacity;
        this.fluidReference = new DummyTank(stack, capacity);
    }

    public void setDrawCapacityInTooltip(boolean drawCapacityInTooltip) {
        this.drawCapacityInTooltip = drawCapacityInTooltip;
    }

    public void setData(int x, int y, IFluidTank fluidReference, boolean outline, boolean drawTextNextTo) {
        this.x = x;
        this.y = y;
        this.fluidReference = fluidReference;
        this.outline = outline;
        this.drawTextNextTo = drawTextNextTo;
    }

    public void draw(GuiGraphics guiGraphics) {
        Minecraft mc = Minecraft.m_91087_();
        int barX = this.x;
        int barY = this.y;
        if (this.outline) {
            guiGraphics.m_280218_(AssetUtil.GUI_INVENTORY_LOCATION, this.x, this.y, 52, 163, 26, 93);
            barX += 4;
            barY += 4;
        }
        guiGraphics.m_280218_(AssetUtil.GUI_INVENTORY_LOCATION, barX, barY, 0, 171, 18, 85);
        FluidStack stack = this.fluidReference.getFluid();
        Fluid fluid = stack.getFluid();
        if (stack != null && !stack.isEmpty() && fluid != null) {
            IClientFluidTypeExtensions fluidTypeExtension = IClientFluidTypeExtensions.of((Fluid)fluid);
            int color = fluidTypeExtension.getTintColor(stack);
            float red = (float)((double)FastColor.ARGB32.m_13665_((int)color) / 255.0);
            float green = (float)((double)FastColor.ARGB32.m_13667_((int)color) / 255.0);
            float blue = (float)((double)FastColor.ARGB32.m_13669_((int)color) / 255.0);
            float alpha = (float)((double)FastColor.ARGB32.m_13655_((int)color) / 255.0);
            ResourceLocation stillTexture = fluidTypeExtension.getStillTexture();
            if (this.sprite == null || this.oldFluid != fluid) {
                TextureAtlasSprite sprite;
                this.oldFluid = stack.getFluid();
                AbstractTexture texture = Minecraft.m_91087_().m_91097_().m_118506_(InventoryMenu.f_39692_);
                if (texture instanceof TextureAtlas && (sprite = ((TextureAtlas)texture).m_118316_(stillTexture)) != null) {
                    this.sprite = sprite;
                }
            }
            if (this.sprite != null) {
                float minU = this.sprite.m_118409_();
                float maxU = this.sprite.m_118410_();
                float minV = this.sprite.m_118411_();
                float maxV = this.sprite.m_118412_();
                float deltaV = maxV - minV;
                double tankLevel = (float)this.fluidReference.getFluidAmount() / (float)this.fluidReference.getCapacity() * 83.0f;
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)InventoryMenu.f_39692_);
                RenderSystem.setShaderColor((float)red, (float)green, (float)blue, (float)alpha);
                RenderSystem.enableBlend();
                int count = 1 + (int)Math.ceil(tankLevel) / 16;
                for (int i = 0; i < count; ++i) {
                    double subHeight = Math.min(16.0, tankLevel - 16.0 * (double)i);
                    double offsetY = 84.0 - 16.0 * (double)i - subHeight;
                    this.drawQuad(barX + 1, (double)barY + offsetY, 16.0, subHeight, minU, (float)((double)maxV - (double)deltaV * (subHeight / 16.0)), maxU, maxV);
                }
                RenderSystem.disableBlend();
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            if (this.drawTextNextTo) {
                guiGraphics.m_280614_(mc.f_91062_, this.getOverlayText(), barX + 25, barY + 78, 0xFFFFFF, false);
            }
        }
    }

    private void drawQuad(double x, double y, double width, double height, float minU, float minV, float maxU, float maxV) {
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder buffer = tesselator.m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        buffer.m_5483_(x, y + height, 0.0).m_7421_(minU, maxV).m_5752_();
        buffer.m_5483_(x + width, y + height, 0.0).m_7421_(maxU, maxV).m_5752_();
        buffer.m_5483_(x + width, y, 0.0).m_7421_(maxU, minV).m_5752_();
        buffer.m_5483_(x, y, 0.0).m_7421_(minU, minV).m_5752_();
        tesselator.m_85914_();
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        if (mouseX >= this.x && mouseY >= this.y && mouseX < this.x + (this.outline ? 26 : 18) && mouseY < this.y + (this.outline ? 93 : 85)) {
            Minecraft mc = Minecraft.m_91087_();
            guiGraphics.m_280666_(mc.f_91062_, Collections.singletonList(this.getOverlayText()), mouseX, mouseY);
        }
    }

    private Component getOverlayText() {
        NumberFormat format = NumberFormat.getInstance();
        FluidStack stack = this.fluidReference.getFluid();
        String cap = format.format(this.fluidReference.getCapacity());
        return stack.isEmpty() ? Component.m_237113_((String)("0/" + cap + " mB")) : Component.m_237113_((String)(format.format(this.fluidReference.getFluidAmount()) + (String)(this.drawCapacityInTooltip ? "/" + cap + " mB " : " mB "))).m_7220_(stack.getDisplayName());
    }

    public static class DummyTank
    implements IFluidTank {
        private final FluidStack fluid;
        private final int capacity;

        public DummyTank(FluidStack fluid, int capacity) {
            this.fluid = fluid;
            this.capacity = capacity;
        }

        @Nonnull
        public FluidStack getFluid() {
            return this.fluid;
        }

        public int getFluidAmount() {
            return this.fluid.getAmount();
        }

        public int getCapacity() {
            return this.capacity;
        }

        public boolean isFluidValid(FluidStack stack) {
            return false;
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            return 0;
        }

        @Nonnull
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            return FluidStack.EMPTY;
        }

        @Nonnull
        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            return FluidStack.EMPTY;
        }
    }
}

