/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.inventory.gui;

import de.ellpeck.actuallyadditions.mod.tile.FilterSettings;
import java.util.ArrayList;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class FilterSettingsGui {
    private final FilterSettings theSettings;
    public Button whitelistButton;
    public Button modButton;
    public Button damageButton;
    public Button nbtButton;

    public FilterSettingsGui(FilterSettings settings, int x, int y, boolean vertical, Consumer<AbstractButton> buttonConsumer, Consumer<Integer> clickConsumer, int idOffset) {
        this.theSettings = settings;
        this.whitelistButton = Button.m_253074_((Component)Component.m_237113_((String)"WH"), $ -> {
            this.theSettings.isWhitelist = !this.theSettings.isWhitelist;
            clickConsumer.accept(idOffset);
        }).m_252987_(x, y, 16, 12).m_253136_();
        buttonConsumer.accept((AbstractButton)this.whitelistButton);
        if (vertical) {
            y += 14;
        } else {
            x += 18;
        }
        this.modButton = Button.m_253074_((Component)Component.m_237113_((String)"MO"), $ -> {
            this.theSettings.respectMod = !this.theSettings.respectMod;
            clickConsumer.accept(idOffset + 1);
        }).m_252987_(x, y, 16, 12).m_253136_();
        buttonConsumer.accept((AbstractButton)this.modButton);
        if (vertical) {
            y += 14;
        } else {
            x += 18;
        }
        this.damageButton = Button.m_253074_((Component)Component.m_237113_((String)"DM"), $ -> {
            this.theSettings.matchDamage = !this.theSettings.matchDamage;
            clickConsumer.accept(idOffset + 2);
        }).m_252987_(x, y, 16, 12).m_253136_();
        buttonConsumer.accept((AbstractButton)this.damageButton);
        if (vertical) {
            y += 14;
        } else {
            x += 18;
        }
        this.nbtButton = Button.m_253074_((Component)Component.m_237113_((String)"DA"), $ -> {
            this.theSettings.matchNBT = !this.theSettings.matchNBT;
            clickConsumer.accept(idOffset + 2);
        }).m_252987_(x, y, 16, 12).m_253136_();
        buttonConsumer.accept((AbstractButton)this.nbtButton);
        this.tick();
    }

    public void tick() {
        this.whitelistButton.m_93666_((Component)Component.m_237113_((String)"WH").m_130940_(this.theSettings.isWhitelist ? ChatFormatting.DARK_GREEN : ChatFormatting.RED));
        this.modButton.m_93666_((Component)Component.m_237113_((String)"MO").m_130940_(this.theSettings.respectMod ? ChatFormatting.DARK_GREEN : ChatFormatting.RED));
        this.damageButton.m_93666_((Component)Component.m_237113_((String)"DM").m_130940_(this.theSettings.matchDamage ? ChatFormatting.DARK_GREEN : ChatFormatting.RED));
        this.nbtButton.m_93666_((Component)Component.m_237113_((String)"DA").m_130940_(this.theSettings.matchNBT ? ChatFormatting.DARK_GREEN : ChatFormatting.RED));
    }

    public void drawHover(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        Minecraft mc = Minecraft.m_91087_();
        ArrayList<MutableComponent> list = new ArrayList<MutableComponent>();
        if (this.whitelistButton.m_5953_((double)mouseX, (double)mouseY)) {
            list.add((this.theSettings.isWhitelist ? Component.m_237115_((String)"info.actuallyadditions.gui.whitelist") : Component.m_237115_((String)"info.actuallyadditions.gui.blacklist")).m_130940_(ChatFormatting.BOLD));
            list.add(Component.m_237115_((String)"info.actuallyadditions.gui.whitelistInfo"));
        } else if (this.modButton.m_5953_((double)mouseX, (double)mouseY)) {
            list.add((this.theSettings.respectMod ? Component.m_237115_((String)"info.actuallyadditions.gui.respectMod") : Component.m_237115_((String)"info.actuallyadditions.gui.ignoreMod")).m_130940_(ChatFormatting.BOLD));
            list.add(Component.m_237115_((String)"info.actuallyadditions.gui.respectModInfo"));
            list.add(Component.m_237115_((String)"info.actuallyadditions.gui.respectModInfo2"));
        } else if (this.damageButton.m_5953_((double)mouseX, (double)mouseY)) {
            list.add((this.theSettings.matchDamage ? Component.m_237115_((String)"info.actuallyadditions.gui.respectDamage") : Component.m_237115_((String)"info.actuallyadditions.gui.ignoreDamage")).m_130940_(ChatFormatting.BOLD));
        } else if (this.nbtButton.m_5953_((double)mouseX, (double)mouseY)) {
            list.add((this.theSettings.matchNBT ? Component.m_237115_((String)"info.actuallyadditions.gui.respectNBT") : Component.m_237115_((String)"info.actuallyadditions.gui.ignoreNBT")).m_130940_(ChatFormatting.BOLD));
        }
        if (!list.isEmpty()) {
            guiGraphics.m_280666_(mc.f_91062_, list, mouseX, mouseY);
        }
    }
}

