/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.inventory.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import de.ellpeck.actuallyadditions.mod.tile.CustomEnergyStorage;
import de.ellpeck.actuallyadditions.mod.util.AssetUtil;
import java.text.NumberFormat;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class EnergyDisplay {
    private CustomEnergyStorage rfReference;
    private int x;
    private int y;
    private boolean outline;
    private boolean drawTextNextTo;

    public EnergyDisplay(int x, int y, CustomEnergyStorage rfReference, boolean outline, boolean drawTextNextTo) {
        this.setData(x, y, rfReference, outline, drawTextNextTo);
    }

    public EnergyDisplay(int x, int y, CustomEnergyStorage rfReference) {
        this(x, y, rfReference, false, false);
    }

    public void setData(int x, int y, CustomEnergyStorage rfReference, boolean outline, boolean drawTextNextTo) {
        this.x = x;
        this.y = y;
        this.rfReference = rfReference;
        this.outline = outline;
        this.drawTextNextTo = drawTextNextTo;
    }

    public void draw(GuiGraphics guiGraphics) {
        Minecraft mc = Minecraft.m_91087_();
        int barX = this.x;
        int barY = this.y;
        if (this.outline) {
            guiGraphics.m_280218_(AssetUtil.GUI_INVENTORY_LOCATION, this.x, this.y, 52, 163, 26, 93);
            barX += 4;
            barY += 4;
        }
        guiGraphics.m_280218_(AssetUtil.GUI_INVENTORY_LOCATION, barX, barY, 18, 171, 18, 85);
        if (this.rfReference.getEnergyStored() > 0) {
            int i = this.rfReference.getEnergyStored() * 83 / this.rfReference.getMaxEnergyStored();
            float[] color = AssetUtil.getWheelColor(mc.f_91073_.m_46467_() % 256L);
            RenderSystem.setShaderColor((float)(color[0] / 255.0f), (float)(color[1] / 255.0f), (float)(color[2] / 255.0f), (float)1.0f);
            guiGraphics.m_280218_(AssetUtil.GUI_INVENTORY_LOCATION, barX + 1, barY + 84 - i, 36, 172, 16, i);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        if (this.drawTextNextTo) {
            guiGraphics.m_280430_(mc.f_91062_, this.getOverlayText(), barX + 25, barY + 78, 0xFFFFFF);
        }
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        if (this.isMouseOver(mouseX, mouseY)) {
            Minecraft mc = Minecraft.m_91087_();
            ArrayList<Component> text = new ArrayList<Component>();
            text.add(this.getOverlayText());
            guiGraphics.m_280666_(mc.f_91062_, text, mouseX, mouseY);
        }
    }

    private boolean isMouseOver(int mouseX, int mouseY) {
        return mouseX >= this.x && mouseY >= this.y && mouseX < this.x + (this.outline ? 26 : 18) && mouseY < this.y + (this.outline ? 93 : 85);
    }

    private Component getOverlayText() {
        NumberFormat format = NumberFormat.getInstance();
        return Component.m_237110_((String)"misc.actuallyadditions.power_long", (Object[])new Object[]{format.format(this.rfReference.getEnergyStored()), format.format(this.rfReference.getMaxEnergyStored())});
    }
}

