/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.inventory.gui;

import de.ellpeck.actuallyadditions.mod.inventory.CrusherContainer;
import de.ellpeck.actuallyadditions.mod.inventory.gui.AAScreen;
import de.ellpeck.actuallyadditions.mod.inventory.gui.EnergyDisplay;
import de.ellpeck.actuallyadditions.mod.network.PacketHandlerHelper;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityCrusher;
import de.ellpeck.actuallyadditions.mod.util.AssetUtil;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CrusherScreen
extends AAScreen<CrusherContainer> {
    private static final ResourceLocation RES_LOC = AssetUtil.getGuiLocation("gui_grinder");
    private static final ResourceLocation RES_LOC_DOUBLE = AssetUtil.getGuiLocation("gui_grinder_double");
    private final TileEntityCrusher tileGrinder;
    private final boolean isDouble;
    private EnergyDisplay energy;
    private Button buttonAutoSplit;

    public CrusherScreen(CrusherContainer container, Inventory inventory, Component title) {
        super(container, inventory, title);
        this.tileGrinder = container.tileGrinder;
        this.isDouble = container.isDouble;
        this.f_97726_ = 176;
        this.f_97727_ = 179;
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.energy = new EnergyDisplay(this.f_97735_ + (this.isDouble ? 13 : 42), this.f_97736_ + 5, this.tileGrinder.storage);
        if (this.isDouble) {
            this.buttonAutoSplit = Button.m_253074_((Component)Component.m_237113_((String)"S"), button -> this.actionPerformed(0)).m_252987_(this.f_97735_ - 10, this.f_97736_, 16, 16).m_253136_();
            this.m_142416_((GuiEventListener)this.buttonAutoSplit);
        }
        this.f_97728_ = (int)((float)this.f_97726_ / 2.0f - (float)this.f_96547_.m_92852_((FormattedText)this.f_96539_) / 2.0f);
        this.f_97729_ = -10;
    }

    protected void actionPerformed(int id) {
        if (this.isDouble && id == 0) {
            PacketHandlerHelper.sendButtonPacket(this.tileGrinder, id);
        }
    }

    public void m_181908_() {
        super.m_181908_();
        if (this.isDouble) {
            this.buttonAutoSplit.m_93666_((Component)Component.m_237113_((String)"S").m_130940_(this.tileGrinder.isAutoSplit ? ChatFormatting.DARK_GREEN : ChatFormatting.RED));
        }
    }

    @Override
    public void m_88315_(@Nonnull GuiGraphics guiGraphics, int x, int y, float f) {
        super.m_88315_(guiGraphics, x, y, f);
        this.energy.render(guiGraphics, x, y);
        if (this.isDouble && this.buttonAutoSplit.m_5953_((double)x, (double)y)) {
            guiGraphics.m_280557_(this.f_96547_, (Component)Component.m_237115_((String)("info.actuallyadditions.gui.autosplititems." + (this.tileGrinder.isAutoSplit ? "on" : "off"))), x, y);
        }
    }

    public void m_7286_(GuiGraphics guiGraphics, float f, int x, int y) {
        int i;
        guiGraphics.m_280218_(AssetUtil.GUI_INVENTORY_LOCATION, this.f_97735_, this.f_97736_ + 93, 0, 0, 176, 86);
        ResourceLocation usedLoc = this.isDouble ? RES_LOC_DOUBLE : RES_LOC;
        guiGraphics.m_280218_(usedLoc, this.f_97735_, this.f_97736_, 0, 0, 176, 93);
        if (this.tileGrinder.firstCrushTime > 0) {
            i = this.tileGrinder.getFirstTimeToScale(23);
            guiGraphics.m_280218_(usedLoc, this.f_97735_ + (this.isDouble ? 51 : 80), this.f_97736_ + 40, 176, 0, 24, i);
        }
        if (this.isDouble && this.tileGrinder.secondCrushTime > 0) {
            i = this.tileGrinder.getSecondTimeToScale(23);
            guiGraphics.m_280218_(usedLoc, this.f_97735_ + 101, this.f_97736_ + 40, 176, 22, 24, i);
        }
        this.energy.draw(guiGraphics);
    }

    public static class CrusherDoubleScreen
    extends CrusherScreen {
        public CrusherDoubleScreen(CrusherContainer crusherContainer, Inventory inventory, Component tile) {
            super(crusherContainer, inventory, tile);
        }
    }
}

