/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.inventory;

import de.ellpeck.actuallyadditions.api.ActuallyTags;
import de.ellpeck.actuallyadditions.mod.inventory.ActuallyContainers;
import de.ellpeck.actuallyadditions.mod.inventory.slot.SlotFilter;
import de.ellpeck.actuallyadditions.mod.inventory.slot.SlotImmovable;
import de.ellpeck.actuallyadditions.mod.inventory.slot.SlotItemHandlerUnconditioned;
import de.ellpeck.actuallyadditions.mod.items.Sack;
import de.ellpeck.actuallyadditions.mod.network.gui.IButtonReactor;
import de.ellpeck.actuallyadditions.mod.tile.FilterSettings;
import de.ellpeck.actuallyadditions.mod.util.ItemStackHandlerAA;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class SackContainer
extends AbstractContainerMenu
implements IButtonReactor {
    private final FilterSettings filter;
    private final ItemStackHandlerAA bagInventory;
    private final Inventory inventory;
    public boolean autoInsert;
    private boolean oldAutoInsert;
    public static final int SIZE = 28;

    public static SackContainer fromNetwork(int windowId, Inventory inv, FriendlyByteBuf data) {
        return new SackContainer(windowId, inv, new ItemStackHandlerAA(28), new FilterSettings(4, false, false, false, false));
    }

    public SackContainer(int windowId, Inventory playerInventory, ItemStackHandlerAA handler, FilterSettings filterIn) {
        super((MenuType)ActuallyContainers.SACK_CONTAINER.get(), windowId);
        int col;
        int row;
        this.inventory = playerInventory;
        this.bagInventory = handler;
        this.filter = filterIn;
        for (row = 0; row < 4; ++row) {
            this.m_38897_((Slot)new SlotFilter(this.filter, row, 155, 10 + row * 18));
        }
        for (row = 0; row < 4; ++row) {
            for (col = 0; col < 7; ++col) {
                this.m_38897_((Slot)new SlotItemHandlerUnconditioned(this.bagInventory, col + row * 7, 10 + col * 18, 10 + row * 18){

                    @Override
                    public boolean m_5857_(ItemStack stack) {
                        return !stack.m_204117_(ActuallyTags.Items.HOLDS_ITEMS) && SackContainer.this.filter.check(stack);
                    }
                });
            }
        }
        for (row = 0; row < 3; ++row) {
            for (col = 0; col < 9; ++col) {
                this.m_38897_(new Slot((Container)playerInventory, col + row * 9 + 9, 8 + col * 18, 94 + row * 18));
            }
        }
        for (int i = 0; i < 9; ++i) {
            if (i == playerInventory.f_35977_) {
                this.m_38897_(new SlotImmovable((Container)playerInventory, i, 8 + i * 18, 152));
                continue;
            }
            this.m_38897_(new Slot((Container)playerInventory, i, 8 + i * 18, 152));
        }
        ItemStack stack = playerInventory.m_36056_();
        if (!stack.m_41619_() && stack.m_41720_() instanceof Sack && stack.m_41782_()) {
            CompoundTag compound = stack.m_41784_();
            this.filter.readFromNBT(compound, "Filter");
            this.autoInsert = compound.m_128471_("AutoInsert");
        }
    }

    public FilterSettings getFilter() {
        return this.filter;
    }

    @Nonnull
    public ItemStack m_7648_(@Nonnull Player player, int slot) {
        int inventoryStart = this.bagInventory.getSlots() + 4;
        int inventoryEnd = inventoryStart + 26;
        int hotbarStart = inventoryEnd + 1;
        int hotbarEnd = hotbarStart + 8;
        Slot theSlot = (Slot)this.f_38839_.get(slot);
        if (theSlot != null && theSlot.m_6657_()) {
            ItemStack newStack = theSlot.m_7993_();
            ItemStack currentStack = newStack.m_41777_();
            if (slot >= inventoryStart ? (!this.filter.check(newStack) || !this.m_38903_(newStack, 4, 32, false)) && (slot <= inventoryEnd ? !this.m_38903_(newStack, hotbarStart, hotbarEnd + 1, false) : slot >= inventoryEnd + 1 && slot < hotbarEnd + 1 && !this.m_38903_(newStack, inventoryStart, inventoryEnd + 1, false)) : !this.m_38903_(newStack, inventoryStart, hotbarEnd + 1, false)) {
                return ItemStack.f_41583_;
            }
            if (newStack.m_41619_()) {
                theSlot.m_5852_(ItemStack.f_41583_);
            } else {
                theSlot.m_6654_();
            }
            if (newStack.m_41613_() == currentStack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            theSlot.m_142406_(player, newStack);
            return currentStack;
        }
        return ItemStack.f_41583_;
    }

    public void m_150399_(int slotId, int dragType, @Nonnull ClickType clickTypeIn, @Nonnull Player player) {
        if (SlotFilter.checkFilter(this, slotId, player)) {
            return;
        }
        if (clickTypeIn == ClickType.SWAP && dragType == this.inventory.f_35977_) {
            return;
        }
        super.m_150399_(slotId, dragType, clickTypeIn, player);
    }

    public void m_6877_(@Nonnull Player player) {
        ItemStack stack = this.inventory.m_36056_();
        if (!stack.m_41619_() && stack.m_41720_() instanceof Sack) {
            CompoundTag compound = stack.m_41784_();
            this.filter.writeToNBT(compound, "Filter");
            compound.m_128379_("AutoInsert", this.autoInsert);
        }
        super.m_6877_(player);
    }

    public boolean m_6875_(@Nonnull Player player) {
        return true;
    }

    @Override
    public void onButtonPressed(int buttonID, Player player) {
        if (buttonID == 0) {
            this.autoInsert = !this.autoInsert;
        } else {
            this.filter.onButtonPressed(buttonID - 1);
        }
    }
}

