/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.inventory;

import com.mojang.datafixers.util.Pair;
import de.ellpeck.actuallyadditions.mod.inventory.ActuallyContainers;
import de.ellpeck.actuallyadditions.mod.inventory.ContainerEnergizer;
import de.ellpeck.actuallyadditions.mod.inventory.slot.SlotItemHandlerUnconditioned;
import de.ellpeck.actuallyadditions.mod.inventory.slot.SlotOutput;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityEnervator;
import de.ellpeck.actuallyadditions.mod.util.StackUtil;
import java.util.Objects;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import org.jetbrains.annotations.Nullable;

public class ContainerEnervator
extends AbstractContainerMenu {
    public final TileEntityEnervator enervator;

    public static ContainerEnervator fromNetwork(int windowId, Inventory inv, FriendlyByteBuf data) {
        return new ContainerEnervator(windowId, inv, (TileEntityEnervator)Objects.requireNonNull(inv.f_35978_.m_9236_().m_7702_(data.m_130135_())));
    }

    public ContainerEnervator(int windowId, Inventory inventory, TileEntityEnervator tile) {
        super((MenuType)ActuallyContainers.ENERVATOR_CONTAINER.get(), windowId);
        int i;
        this.enervator = tile;
        this.m_38897_((Slot)new SlotItemHandlerUnconditioned(this.enervator.inv, 0, 76, 73));
        this.m_38897_((Slot)new SlotOutput(this.enervator.inv, 1, 76, 42));
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)inventory, j + i * 9 + 9, 8 + j * 18, 97 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)inventory, i, 8 + i * 18, 155));
        }
        for (int k = 0; k < 4; ++k) {
            final EquipmentSlot slot = ContainerEnergizer.VALID_EQUIPMENT_SLOTS[k];
            this.m_38897_(new Slot((Container)inventory, 39 - k, 102, 19 + k * 18){

                public int m_6641_() {
                    return 1;
                }

                public boolean m_5857_(ItemStack stack) {
                    return StackUtil.isValid(stack) && stack.m_41720_() instanceof ArmorItem;
                }

                @Nullable
                public Pair<ResourceLocation, ResourceLocation> m_7543_() {
                    return Pair.of((Object)InventoryMenu.f_39692_, (Object)InventoryMenu.f_39699_[slot.m_20749_()]);
                }
            });
        }
    }

    public ItemStack m_7648_(Player player, int slot) {
        int inventoryStart = 2;
        int inventoryEnd = inventoryStart + 26;
        int hotbarStart = inventoryEnd + 1;
        int hotbarEnd = hotbarStart + 8;
        Slot theSlot = (Slot)this.f_38839_.get(slot);
        if (theSlot != null && theSlot.m_6657_()) {
            ItemStack newStack = theSlot.m_7993_();
            ItemStack currentStack = newStack.m_41777_();
            if (slot == 1) {
                if (!this.m_38903_(newStack, inventoryStart, hotbarEnd + 1, true)) {
                    return ItemStack.f_41583_;
                }
                theSlot.m_40234_(newStack, currentStack);
            } else if (slot >= inventoryStart ? (newStack.getCapability(ForgeCapabilities.ENERGY).isPresent() ? !this.m_38903_(newStack, 0, 1, false) : (slot >= inventoryStart && slot <= inventoryEnd ? !this.m_38903_(newStack, hotbarStart, hotbarEnd + 1, false) : slot >= inventoryEnd + 1 && slot < hotbarEnd + 1 && !this.m_38903_(newStack, inventoryStart, inventoryEnd + 1, false))) : !this.m_38903_(newStack, inventoryStart, hotbarEnd + 1, false)) {
                return ItemStack.f_41583_;
            }
            if (!StackUtil.isValid(newStack)) {
                theSlot.m_5852_(ItemStack.f_41583_);
            } else {
                theSlot.m_6654_();
            }
            if (newStack.m_41613_() == currentStack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            theSlot.m_142406_(player, newStack);
            return currentStack;
        }
        return ItemStack.f_41583_;
    }

    public boolean m_6875_(Player player) {
        return this.enervator.canPlayerUse(player);
    }
}

