/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.gen.village;

import de.ellpeck.actuallyadditions.mod.ActuallyAdditions;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class BasicTradeList
implements VillagerTrades.ItemListing {
    private final ItemStack input;
    private final PriceRange inputAmount;
    private final ItemStack output;
    private final PriceRange outputAmount;
    private int maxUses = 3;
    private int villagerXp = 15;
    private float priceMultiplier = 0.05f;

    public BasicTradeList(ItemStack input, PriceRange inputAmount, ItemStack output, PriceRange outputAmount) {
        this.input = input;
        this.inputAmount = inputAmount;
        this.output = output;
        this.outputAmount = outputAmount;
    }

    public BasicTradeList(PriceRange emeraldInput, ItemStack output, PriceRange outputAmount) {
        this(new ItemStack((ItemLike)Items.f_42616_), emeraldInput, output, outputAmount);
    }

    public BasicTradeList(ItemStack input, PriceRange inputAmount, PriceRange emeraldOutput) {
        this(input, inputAmount, new ItemStack((ItemLike)Items.f_42616_), emeraldOutput);
    }

    public BasicTradeList withMaxUses(int maxUses) {
        this.maxUses = maxUses;
        return this;
    }

    public BasicTradeList withVillagerXp(int villagerXp) {
        this.villagerXp = villagerXp;
        return this;
    }

    public BasicTradeList withPriceMultiplier(float priceMultiplier) {
        this.priceMultiplier = priceMultiplier;
        return this;
    }

    @Nullable
    public MerchantOffer m_213663_(Entity trader, RandomSource random) {
        ItemStack in = this.input.m_41777_();
        in.m_41764_(this.inputAmount.getPrice(random));
        ItemStack out = this.output.m_41777_();
        out.m_41764_(this.outputAmount.getPrice(random));
        return new MerchantOffer(in, out, this.maxUses, this.villagerXp, this.priceMultiplier);
    }

    public static class PriceRange
    extends Tuple<Integer, Integer> {
        public PriceRange(int min, int max) {
            super((Object)min, (Object)max);
            if (max < min) {
                ActuallyAdditions.LOGGER.warn("PriceRange({}, {}) invalid, {} smaller than {}", new Object[]{min, max, max, min});
            }
        }

        public int getPrice(RandomSource rand) {
            return (Integer)this.m_14418_() >= (Integer)this.m_14419_() ? (Integer)this.m_14418_() : (Integer)this.m_14418_() + rand.m_188503_((Integer)this.m_14419_() - (Integer)this.m_14418_() + 1);
        }
    }
}

