/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.gen;

import com.mojang.datafixers.util.Pair;
import de.ellpeck.actuallyadditions.mod.blocks.ActuallyBlocks;
import de.ellpeck.actuallyadditions.mod.gen.ActuallyProcessorLists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.structure.pools.SinglePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.AlwaysTrueTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.ProcessorRule;
import net.minecraft.world.level.levelgen.structure.templatesystem.RandomBlockMatchTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.minecraftforge.event.server.ServerAboutToStartEvent;

public class ActuallyVillages {
    private static void addBuildingToPool(Registry<StructureTemplatePool> templatePoolRegistry, Registry<StructureProcessorList> processorListRegistry, ResourceLocation poolRL, String nbtPieceRL, int weight) {
        Holder.Reference emptyProcessorList = processorListRegistry.m_246971_(ActuallyProcessorLists.ENGINEER_HOUSE_PROCESSOR_LIST_KEY);
        StructureTemplatePool pool = (StructureTemplatePool)templatePoolRegistry.m_7745_(poolRL);
        if (pool == null) {
            return;
        }
        SinglePoolElement piece = (SinglePoolElement)SinglePoolElement.m_210512_((String)nbtPieceRL, (Holder)emptyProcessorList).apply(StructureTemplatePool.Projection.RIGID);
        for (int i = 0; i < weight; ++i) {
            pool.f_210560_.add((Object)piece);
        }
        ArrayList<Pair> listOfPieceEntries = new ArrayList<Pair>(pool.f_210559_);
        listOfPieceEntries.add(new Pair((Object)piece, (Object)weight));
        pool.f_210559_ = listOfPieceEntries;
    }

    public static void modifyVillageStructures(ServerAboutToStartEvent event) {
        Registry templatePoolRegistry = (Registry)event.getServer().m_206579_().m_6632_(Registries.f_256948_).orElseThrow();
        Registry processorListRegistry = (Registry)event.getServer().m_206579_().m_6632_(Registries.f_257011_).orElseThrow();
        ActuallyVillages.addBuildingToPool((Registry<StructureTemplatePool>)templatePoolRegistry, (Registry<StructureProcessorList>)processorListRegistry, new ResourceLocation("minecraft:village/plains/houses"), "actuallyadditions:andrew_period_house", 10);
        ActuallyVillages.addBuildingToPool((Registry<StructureTemplatePool>)templatePoolRegistry, (Registry<StructureProcessorList>)processorListRegistry, new ResourceLocation("minecraft:village/snowy/houses"), "actuallyadditions:andrew_period_house", 10);
        ActuallyVillages.addBuildingToPool((Registry<StructureTemplatePool>)templatePoolRegistry, (Registry<StructureProcessorList>)processorListRegistry, new ResourceLocation("minecraft:village/savanna/houses"), "actuallyadditions:andrew_period_house", 10);
        ActuallyVillages.addBuildingToPool((Registry<StructureTemplatePool>)templatePoolRegistry, (Registry<StructureProcessorList>)processorListRegistry, new ResourceLocation("minecraft:village/taiga/houses"), "actuallyadditions:andrew_period_house", 10);
        ActuallyVillages.addBuildingToPool((Registry<StructureTemplatePool>)templatePoolRegistry, (Registry<StructureProcessorList>)processorListRegistry, new ResourceLocation("minecraft:village/desert/houses"), "actuallyadditions:andrew_period_house", 50);
        RuleProcessor cropProcessor = new RuleProcessor(List.of(new ProcessorRule((RuleTest)new RandomBlockMatchTest(Blocks.f_50092_, 0.3f), (RuleTest)AlwaysTrueTest.f_73954_, ActuallyBlocks.RICE.get().m_49966_()), new ProcessorRule((RuleTest)new RandomBlockMatchTest(Blocks.f_50092_, 0.25f), (RuleTest)AlwaysTrueTest.f_73954_, ActuallyBlocks.COFFEE.get().m_49966_()), new ProcessorRule((RuleTest)new RandomBlockMatchTest(Blocks.f_50092_, 0.1f), (RuleTest)AlwaysTrueTest.f_73954_, ActuallyBlocks.CANOLA.get().m_49966_()), new ProcessorRule((RuleTest)new RandomBlockMatchTest(Blocks.f_50092_, 0.05f), (RuleTest)AlwaysTrueTest.f_73954_, ActuallyBlocks.FLAX.get().m_49966_())));
        ActuallyVillages.addNewRuleToProcessorList(new ResourceLocation("minecraft:farm_plains"), (StructureProcessor)cropProcessor, (Registry<StructureProcessorList>)processorListRegistry);
        ActuallyVillages.addNewRuleToProcessorList(new ResourceLocation("minecraft:farm_savanna"), (StructureProcessor)cropProcessor, (Registry<StructureProcessorList>)processorListRegistry);
        ActuallyVillages.addNewRuleToProcessorList(new ResourceLocation("minecraft:farm_snowy"), (StructureProcessor)cropProcessor, (Registry<StructureProcessorList>)processorListRegistry);
        ActuallyVillages.addNewRuleToProcessorList(new ResourceLocation("minecraft:farm_taiga"), (StructureProcessor)cropProcessor, (Registry<StructureProcessorList>)processorListRegistry);
        ActuallyVillages.addNewRuleToProcessorList(new ResourceLocation("minecraft:farm_desert"), (StructureProcessor)cropProcessor, (Registry<StructureProcessorList>)processorListRegistry);
        ActuallyVillages.addNewRuleToProcessorList(new ResourceLocation("repurposed_structures:villages/badlands/crop_replacement"), (StructureProcessor)cropProcessor, (Registry<StructureProcessorList>)processorListRegistry);
        ActuallyVillages.addNewRuleToProcessorList(new ResourceLocation("repurposed_structures:villages/birch/crop_randomizer"), (StructureProcessor)cropProcessor, (Registry<StructureProcessorList>)processorListRegistry);
        ActuallyVillages.addNewRuleToProcessorList(new ResourceLocation("repurposed_structures:villages/dark_forest/crop_randomizer"), (StructureProcessor)cropProcessor, (Registry<StructureProcessorList>)processorListRegistry);
        ActuallyVillages.addNewRuleToProcessorList(new ResourceLocation("repurposed_structures:villages/giant_taiga/crop_randomizer"), (StructureProcessor)cropProcessor, (Registry<StructureProcessorList>)processorListRegistry);
        ActuallyVillages.addNewRuleToProcessorList(new ResourceLocation("repurposed_structures:villages/jungle/crop_randomizer"), (StructureProcessor)cropProcessor, (Registry<StructureProcessorList>)processorListRegistry);
        ActuallyVillages.addNewRuleToProcessorList(new ResourceLocation("repurposed_structures:villages/mountains/crop_randomizer"), (StructureProcessor)cropProcessor, (Registry<StructureProcessorList>)processorListRegistry);
        ActuallyVillages.addNewRuleToProcessorList(new ResourceLocation("repurposed_structures:villages/oak/crop_randomizer"), (StructureProcessor)cropProcessor, (Registry<StructureProcessorList>)processorListRegistry);
        ActuallyVillages.addNewRuleToProcessorList(new ResourceLocation("repurposed_structures:villages/swamp/crop_randomizer"), (StructureProcessor)cropProcessor, (Registry<StructureProcessorList>)processorListRegistry);
    }

    private static void addNewRuleToProcessorList(ResourceLocation targetProcessorList, StructureProcessor processorToAdd, Registry<StructureProcessorList> processorListRegistry) {
        processorListRegistry.m_6612_(targetProcessorList).ifPresent(processorList -> {
            ArrayList<StructureProcessor> newSafeList = new ArrayList<StructureProcessor>(processorList.m_74425_());
            newSafeList.add(processorToAdd);
            processorList.f_74422_ = newSafeList;
        });
    }
}

