/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.fluids;

import de.ellpeck.actuallyadditions.mod.blocks.ActuallyBlocks;
import de.ellpeck.actuallyadditions.mod.fluids.InitFluids;
import de.ellpeck.actuallyadditions.mod.items.ActuallyItems;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.common.SoundActions;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.registries.RegistryObject;

public class FluidAA
implements Supplier<Fluid> {
    private String name;
    private final ResourceLocation stillTexture;
    private final ResourceLocation flowingTexture;
    private RegistryObject<FluidType> fluidType;
    private RegistryObject<ForgeFlowingFluid> source;
    private RegistryObject<ForgeFlowingFluid> flowing;
    private RegistryObject<LiquidBlock> fluidBlock;
    private RegistryObject<Item> bucket;

    public String getName() {
        return this.name;
    }

    public static ForgeFlowingFluid.Properties createProperties(Supplier<FluidType> type, Supplier<ForgeFlowingFluid> still, Supplier<ForgeFlowingFluid> flowing, RegistryObject<Item> bucket, Supplier<LiquidBlock> block) {
        return new ForgeFlowingFluid.Properties(type, still, flowing).bucket(bucket).block(block);
    }

    public FluidAA(String fluidName, String textureName) {
        this.name = fluidName;
        this.stillTexture = new ResourceLocation("actuallyadditions", "block/" + textureName + "_still");
        this.flowingTexture = new ResourceLocation("actuallyadditions", "block/" + textureName + "_flowing");
        this.fluidType = InitFluids.FLUID_TYPES.register(this.name, () -> new FluidType(FluidAA.createTypeProperties()){

            public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
                consumer.accept(new IClientFluidTypeExtensions(){

                    public ResourceLocation getStillTexture() {
                        return FluidAA.this.stillTexture;
                    }

                    public ResourceLocation getFlowingTexture() {
                        return FluidAA.this.flowingTexture;
                    }
                });
            }
        });
        this.source = InitFluids.FLUIDS.register(this.name, () -> new ForgeFlowingFluid.Source(FluidAA.createProperties(this.fluidType, this.source, this.flowing, this.bucket, this.fluidBlock)));
        this.flowing = InitFluids.FLUIDS.register(this.name + "_flowing", () -> new ForgeFlowingFluid.Flowing(FluidAA.createProperties(this.fluidType, this.source, this.flowing, this.bucket, this.fluidBlock)));
        this.fluidBlock = ActuallyBlocks.BLOCKS.register(this.name, () -> new LiquidBlock(this.source, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_49990_)));
        this.bucket = ActuallyItems.ITEMS.register(this.name + "_bucket", () -> new BucketItem(this.source, new Item.Properties().m_41495_(Items.f_42446_).m_41487_(1)));
    }

    public FluidType getFluidType() {
        return (FluidType)this.fluidType.get();
    }

    @Override
    public Fluid get() {
        return (Fluid)this.source.get();
    }

    public Block getBlock() {
        return (Block)this.fluidBlock.get();
    }

    public Item getBucket() {
        return (Item)this.bucket.get();
    }

    public FlowingFluid getFlowing() {
        return (FlowingFluid)this.flowing.get();
    }

    public static FluidType.Properties createTypeProperties() {
        return FluidType.Properties.create().canSwim(true).canDrown(true).pathType(BlockPathTypes.LAVA).sound(SoundActions.BUCKET_FILL, SoundEvents.f_11781_).sound(SoundActions.BUCKET_EMPTY, SoundEvents.f_11778_);
    }
}

