/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.event;

import de.ellpeck.actuallyadditions.mod.ActuallyAdditions;
import de.ellpeck.actuallyadditions.mod.blocks.BlockLaserRelay;
import de.ellpeck.actuallyadditions.mod.config.CommonConfig;
import de.ellpeck.actuallyadditions.mod.config.values.ConfigBoolValues;
import de.ellpeck.actuallyadditions.mod.data.PlayerData;
import de.ellpeck.actuallyadditions.mod.data.WorldData;
import de.ellpeck.actuallyadditions.mod.items.ActuallyItems;
import de.ellpeck.actuallyadditions.mod.items.ItemTag;
import de.ellpeck.actuallyadditions.mod.items.Sack;
import de.ellpeck.actuallyadditions.mod.network.PacketHandlerHelper;
import de.ellpeck.actuallyadditions.mod.sack.SackManager;
import de.ellpeck.actuallyadditions.mod.tile.FilterSettings;
import de.ellpeck.actuallyadditions.mod.util.ItemStackHandlerAA;
import de.ellpeck.actuallyadditions.mod.util.ItemUtil;
import de.ellpeck.actuallyadditions.mod.util.StackUtil;
import java.util.Locale;
import java.util.Optional;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class CommonEvents {
    @SubscribeEvent
    public void onBlockRightClick(PlayerInteractEvent.RightClickBlock event) {
        if (event.getLevel().f_46443_) {
            return;
        }
        if (event.getLevel().m_8055_(event.getHitVec().m_82425_()).m_60734_() instanceof BlockLaserRelay && event.getItemStack().m_150930_(CommonConfig.Other.relayConfigureItem)) {
            event.setUseItem(Event.Result.DENY);
            event.setUseBlock(Event.Result.ALLOW);
        }
    }

    @SubscribeEvent
    public void onItemPickup(EntityItemPickupEvent event) {
        if (event.isCanceled() || event.getResult() == Event.Result.ALLOW) {
            return;
        }
        Player player = event.getEntity();
        ItemEntity item = event.getItem();
        if (item != null && item.m_6084_()) {
            ItemStack stack = item.m_32055_();
            if (StackUtil.isValid(stack)) {
                for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
                    ItemStack invStack;
                    if (i != player.m_150109_().f_35977_ && StackUtil.isValid(invStack = player.m_150109_().m_8020_(i)) && invStack.m_41720_() instanceof Sack && invStack.m_41782_() && invStack.m_41784_().m_128471_("AutoInsert")) {
                        boolean changed = false;
                        boolean isVoid = ((Sack)invStack.m_41720_()).isVoid;
                        FilterSettings filter = new FilterSettings(4, false, false, false, false);
                        filter.readFromNBT(invStack.m_41784_(), "Filter");
                        if (isVoid) {
                            if (filter.check(stack)) {
                                stack.m_41764_(0);
                                changed = true;
                            }
                        } else {
                            Optional<ItemStackHandlerAA> optHandler = SackManager.get().getHandler(invStack);
                            if (optHandler.isEmpty()) continue;
                            ItemStackHandlerAA inv = optHandler.get();
                            if (filter.check(stack)) {
                                for (int j = 0; j < inv.getSlots(); ++j) {
                                    ItemStack bagStack = inv.getStackInSlot(j);
                                    if (StackUtil.isValid(bagStack)) {
                                        int maxTransfer;
                                        if (ItemUtil.canBeStacked(bagStack, stack) && (maxTransfer = Math.min(stack.m_41613_(), stack.m_41741_() - bagStack.m_41613_())) > 0) {
                                            inv.setStackInSlot(j, StackUtil.grow(bagStack, maxTransfer));
                                            stack.m_41774_(maxTransfer);
                                            changed = true;
                                        }
                                    } else {
                                        inv.setStackInSlot(j, stack.m_41777_());
                                        stack.m_41764_(0);
                                        changed = true;
                                    }
                                    if (stack.m_41619_()) break;
                                }
                            }
                        }
                        if (changed) {
                            event.setResult(Event.Result.ALLOW);
                        }
                    }
                    if (!StackUtil.isValid(stack)) break;
                }
            }
            item.m_32045_(stack);
        }
    }

    @SubscribeEvent
    public void onEntityDropEvent(LivingDropsEvent event) {
        if (event.getEntity().m_9236_() != null && !event.getEntity().m_9236_().f_46443_ && event.getSource().m_7639_() instanceof Player && ConfigBoolValues.DO_SPIDER_DROPS.isEnabled() && event.getEntity() instanceof Spider && event.getEntity().m_9236_().f_46441_.m_188503_(20) <= event.getLootingLevel() * 2) {
            event.getDrops().add(new ItemEntity(event.getEntity().m_9236_(), event.getEntity().m_20185_(), event.getEntity().m_20186_(), event.getEntity().m_20189_(), new ItemStack((ItemLike)Blocks.f_50033_, event.getEntity().m_9236_().f_46441_.m_188503_(2 + event.getLootingLevel()) + 1)));
        }
    }

    @SubscribeEvent
    public void onLogInEvent(PlayerEvent.PlayerLoggedInEvent event) {
        Player player;
        if (!event.getEntity().m_9236_().f_46443_ && (player = event.getEntity()) instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            PacketHandlerHelper.syncPlayerData((Player)player2, true);
            ActuallyAdditions.LOGGER.info("Sending Player Data to player " + player2.m_7755_() + " with UUID " + player2.m_20148_() + ".");
        }
    }

    @SubscribeEvent
    public void onCraftedEvent(PlayerEvent.ItemCraftedEvent event) {
        PlayerData.PlayerSave save;
        String name;
        if (((Boolean)CommonConfig.Other.GIVE_BOOKLET_ON_FIRST_CRAFT.get()).booleanValue() && !event.getEntity().m_9236_().f_46443_ && StackUtil.isValid(event.getCrafting()) && event.getCrafting().m_41720_() != ActuallyItems.ITEM_BOOKLET.get() && (name = ForgeRegistries.ITEMS.getKey((Object)event.getCrafting().m_41720_()).toString()) != null && name.toLowerCase(Locale.ROOT).contains("actuallyadditions") && (save = PlayerData.getDataFromPlayer(event.getEntity())) != null && !save.bookGottenAlready) {
            save.bookGottenAlready = true;
            WorldData.get(event.getEntity().m_20193_()).m_77762_();
            ItemEntity entityItem = new ItemEntity(event.getEntity().m_9236_(), event.getEntity().m_20185_(), event.getEntity().m_20186_(), event.getEntity().m_20189_(), new ItemStack((ItemLike)ActuallyItems.ITEM_BOOKLET.get()));
            entityItem.m_32010_(0);
            event.getEntity().m_9236_().m_7967_((Entity)entityItem);
        }
    }

    @SubscribeEvent
    public void onSmeltedEvent(PlayerEvent.ItemSmeltedEvent event) {
    }

    @SubscribeEvent
    public void onPickupEvent(EntityItemPickupEvent event) {
    }

    @SubscribeEvent
    public void onAnvilEvent(AnvilUpdateEvent event) {
        if (!event.getLeft().m_41619_() && event.getLeft().m_41720_() instanceof ItemTag && event.getName() != null && !event.getName().isEmpty()) {
            event.setCost(0);
            if (ResourceLocation.m_135830_((String)event.getName())) {
                TagKey tagKey = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)new ResourceLocation(event.getName()));
                Optional tag = BuiltInRegistries.f_257033_.m_203431_(tagKey);
                if (tag.isPresent()) {
                    ItemStack stack = event.getLeft().m_41777_();
                    stack.m_41784_().m_128359_("ItemTag", tagKey.f_203868_().toString());
                    event.setOutput(stack);
                } else {
                    event.setCanceled(true);
                }
            } else {
                event.setCanceled(true);
            }
        }
    }
}

