/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.event;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import de.ellpeck.actuallyadditions.mod.blocks.IHudDisplay;
import de.ellpeck.actuallyadditions.mod.config.CommonConfig;
import de.ellpeck.actuallyadditions.mod.data.WorldData;
import de.ellpeck.actuallyadditions.mod.inventory.gui.EnergyDisplay;
import de.ellpeck.actuallyadditions.mod.items.DrillItem;
import de.ellpeck.actuallyadditions.mod.items.ItemDrillUpgrade;
import de.ellpeck.actuallyadditions.mod.tile.IEnergyDisplay;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityBase;
import de.ellpeck.actuallyadditions.mod.util.AssetUtil;
import de.ellpeck.actuallyadditions.mod.util.StackUtil;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.event.RenderHighlightEvent;
import net.minecraftforge.client.gui.overlay.GuiOverlayManager;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@OnlyIn(value=Dist.CLIENT)
public class ClientEvents {
    private static final Component ADVANCED_INFO_TEXT_PRE = Component.m_237113_((String)"  -").m_130940_(ChatFormatting.DARK_GRAY);
    private static final Component ADVANCED_INFO_HEADER_PRE = Component.m_237113_((String)"  -").m_130940_(ChatFormatting.GRAY);
    private static EnergyDisplay energyDisplay;

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91073_ == null) {
                WorldData.clear();
            }
        }
    }

    @SubscribeEvent
    public void onTooltipEvent(ItemTooltipEvent event) {
    }

    @SubscribeEvent
    public void onGameOverlay(RenderGuiOverlayEvent.Post event) {
        Minecraft minecraft = Minecraft.m_91087_();
        if (event.getOverlay() == GuiOverlayManager.findOverlay((ResourceLocation)new ResourceLocation("portal")) && minecraft.f_91080_ == null) {
            GuiGraphics guiGraphics = event.getGuiGraphics();
            LocalPlayer player = minecraft.f_91074_;
            if (player == null) {
                return;
            }
            HitResult posHit = minecraft.f_91077_;
            Font font = minecraft.f_91062_;
            ItemStack stack = player.m_21205_();
            if (StackUtil.isValid(stack) && stack.m_41720_() instanceof IHudDisplay) {
                ((IHudDisplay)stack.m_41720_()).displayHud(guiGraphics, minecraft, (Player)player, stack, posHit, event.getWindow());
            }
            if (posHit != null && posHit.m_6662_() == HitResult.Type.BLOCK) {
                IEnergyDisplay display;
                TileEntityBase base;
                BlockHitResult rayCast = (BlockHitResult)posHit;
                Block blockHit = minecraft.f_91073_.m_8055_(rayCast.m_82425_()).m_60734_();
                BlockEntity tileHit = minecraft.f_91073_.m_7702_(rayCast.m_82425_());
                if (blockHit instanceof IHudDisplay) {
                    ((IHudDisplay)blockHit).displayHud(guiGraphics, minecraft, (Player)player, stack, posHit, event.getWindow());
                }
                if (tileHit instanceof TileEntityBase && (base = (TileEntityBase)tileHit).isRedstoneToggle()) {
                    MutableComponent component = Component.m_237115_((String)"info.actuallyadditions.redstoneMode").m_130946_(": ").m_7220_((Component)Component.m_237115_((String)("info.actuallyadditions.redstoneMode." + (base.isPulseMode ? "pulse" : "deactivation"))).m_130940_(ChatFormatting.DARK_RED));
                    guiGraphics.m_280430_(font, (Component)component, (int)((float)event.getWindow().m_85445_() / 2.0f + 5.0f), (int)((float)event.getWindow().m_85446_() / 2.0f + 5.0f), 0xFFFFFF);
                    MutableComponent expl = !stack.m_41619_() && stack.m_41720_() == CommonConfig.Other.redstoneConfigureItem ? Component.m_237115_((String)"info.actuallyadditions.redstoneMode.validItem").m_130940_(ChatFormatting.GREEN) : Component.m_237110_((String)"info.actuallyadditions.redstoneMode.invalidItem", (Object[])new Object[]{Component.m_237115_((String)CommonConfig.Other.redstoneConfigureItem.m_5456_().m_5524_()).getString()}).m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC});
                    guiGraphics.m_280430_(font, (Component)expl, (int)((float)event.getWindow().m_85445_() / 2.0f + 5.0f), (int)((float)event.getWindow().m_85446_() / 2.0f + 15.0f), 0xFFFFFF);
                }
                if (tileHit instanceof IEnergyDisplay && (!(display = (IEnergyDisplay)tileHit).needsHoldShift() || player.m_6144_())) {
                    if (energyDisplay == null) {
                        energyDisplay = new EnergyDisplay(0, 0, null);
                    }
                    energyDisplay.setData(2, event.getWindow().m_85446_() - 96, display.getEnergyStorage(), true, true);
                    PoseStack matrices = guiGraphics.m_280168_();
                    matrices.m_85836_();
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    energyDisplay.draw(guiGraphics);
                    matrices.m_85849_();
                }
            }
        }
    }

    @SubscribeEvent
    public void renderBlockHighlight(RenderHighlightEvent.Block event) {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (mc.f_91074_ == null) {
            return;
        }
        ItemStack stack = player.m_21205_();
        Item item = stack.m_41720_();
        if (item instanceof DrillItem) {
            DrillItem drillItem = (DrillItem)item;
            if (!player.m_6144_() && drillItem.getHasUpgrade(stack, ItemDrillUpgrade.UpgradeType.THREE_BY_THREE)) {
                Level level = player.m_9236_();
                Vec3 vec3 = event.getCamera().m_90583_();
                double d0 = vec3.m_7096_();
                double d1 = vec3.m_7098_();
                double d2 = vec3.m_7094_();
                BlockHitResult blockHitResult = event.getTarget();
                BlockPos targetPos = blockHitResult.m_82425_();
                BlockState blockState = level.m_8055_(targetPos);
                VertexConsumer lineConsumer = event.getMultiBufferSource().m_6299_(RenderType.m_110504_());
                if (stack.m_41735_(blockState)) {
                    int radius = 0;
                    if (drillItem.getHasUpgrade(stack, ItemDrillUpgrade.UpgradeType.FIVE_BY_FIVE)) {
                        radius = 2;
                    } else if (drillItem.getHasUpgrade(stack, ItemDrillUpgrade.UpgradeType.THREE_BY_THREE)) {
                        radius = 1;
                    }
                    if (radius == 0) {
                        return;
                    }
                    List<BlockPos> coords = drillItem.gatherBreakingPositions(stack, radius, level, targetPos, blockHitResult.m_82434_(), (Player)player);
                    for (BlockPos blockPos : coords) {
                        if (blockPos.equals((Object)targetPos)) continue;
                        AssetUtil.renderHitOutline(event.getPoseStack(), lineConsumer, (Entity)player, d0, d1, d2, level, blockPos, level.m_8055_(blockPos));
                    }
                }
            }
        }
    }
}

