/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.entity;

import de.ellpeck.actuallyadditions.mod.config.CommonConfig;
import de.ellpeck.actuallyadditions.mod.misc.apiimpl.farmer.DefaultFarmerBehavior;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.GrassBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.FarmlandWaterManager;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.ticket.AABBTicket;
import net.minecraftforge.network.NetworkHooks;

public class EntityWorm
extends Entity {
    public int timer;
    private AABBTicket waterTicket;

    public EntityWorm(EntityType<?> type, Level world) {
        super(type, world);
        this.m_20011_(new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0));
    }

    public static boolean canWormify(Level world, BlockPos pos, BlockState state) {
        boolean rightBlock;
        Block block = state.m_60734_();
        boolean bl = rightBlock = block instanceof FarmBlock || block == Blocks.f_50493_ || block instanceof GrassBlock;
        if (rightBlock) {
            BlockPos posUp = pos.m_7494_();
            BlockState stateUp = world.m_8055_(posUp);
            Block blockUp = stateUp.m_60734_();
            return blockUp instanceof IPlantable || blockUp instanceof BushBlock || stateUp.m_247087_();
        }
        return false;
    }

    public void m_142687_(Entity.RemovalReason reason) {
        if (this.waterTicket != null) {
            this.waterTicket.invalidate();
        }
        super.m_142687_(reason);
    }

    protected void m_6089_() {
        if (this.waterTicket != null) {
            this.waterTicket.invalidate();
        }
        super.m_6089_();
    }

    public void m_6034_(double pX, double pY, double pZ) {
        super.m_6034_(pX, pY, pZ);
        if (this.m_9236_().f_46443_) {
            return;
        }
        if (this.waterTicket != null) {
            this.waterTicket.invalidate();
        }
        AABB aabb = new AABB(this.m_20185_() - 1.5, this.m_20186_() - 1.5, this.m_20189_() - 1.0, this.m_20185_() + 1.5, this.m_20186_() + 0.5, this.m_20189_() + 1.5);
        this.waterTicket = FarmlandWaterManager.addAABBTicket((Level)this.m_9236_(), (AABB)aabb);
    }

    public boolean canUpdate() {
        return true;
    }

    public void m_8119_() {
        if (!this.m_9236_().f_46443_) {
            int dieTime;
            ++this.timer;
            if (this.timer % 50 == 0) {
                for (int x = -1; x <= 1; ++x) {
                    for (int z = -1; z <= 1; ++z) {
                        boolean isMiddlePose;
                        BlockPos pos = BlockPos.m_274561_((double)(this.m_20185_() + (double)x), (double)this.m_20186_(), (double)(this.m_20189_() + (double)z));
                        BlockState state = this.m_9236_().m_8055_(pos);
                        Block block = state.m_60734_();
                        boolean bl = isMiddlePose = x == 0 && z == 0;
                        if (EntityWorm.canWormify(this.m_9236_(), pos, state)) {
                            BlockState plantState;
                            Block plantBlock;
                            boolean isFarmland = block instanceof FarmBlock;
                            if (!isFarmland && (isMiddlePose || this.m_9236_().f_46441_.m_188501_() >= 0.45f)) {
                                DefaultFarmerBehavior.useHoeAt(this.m_9236_(), pos);
                            }
                            if (!isFarmland || !(this.m_9236_().f_46441_.m_188501_() >= 0.95f)) continue;
                            BlockPos plant = pos.m_7494_();
                            if (this.m_9236_().m_46859_(plant) || !((plantBlock = (plantState = this.m_9236_().m_8055_(plant)).m_60734_()) instanceof BonemealableBlock) && !(plantBlock instanceof IPlantable) || plantBlock instanceof GrassBlock) continue;
                            plantBlock.m_213898_(plantState, (ServerLevel)this.m_9236_(), plant, this.m_9236_().f_46441_);
                            BlockState newState = this.m_9236_().m_8055_(plant);
                            if (newState == plantState) continue;
                            this.m_9236_().m_46796_(2005, plant, 0);
                            continue;
                        }
                        if (!isMiddlePose) continue;
                        this.m_6089_();
                    }
                }
            }
            if ((dieTime = ((Integer)CommonConfig.Other.WORMS_DIE_TIME.get()).intValue()) > 0 && this.timer >= dieTime) {
                this.m_6089_();
            }
        }
    }

    protected void m_8097_() {
    }

    protected void m_7378_(CompoundTag compound) {
        this.timer = compound.m_128451_("Timer");
    }

    protected void m_7380_(CompoundTag compound) {
        compound.m_128405_("Timer", this.timer);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

