/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.data;

import de.ellpeck.actuallyadditions.api.booklet.IBookletPage;
import de.ellpeck.actuallyadditions.mod.data.WorldData;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;

public final class PlayerData {
    private static PlayerSave clientData = null;

    public static PlayerSave getDataFromPlayer(Player player) {
        PlayerSave save;
        if (!(player.m_20193_() instanceof ServerLevel)) {
            if (clientData == null) {
                clientData = new PlayerSave(player.m_20148_());
            }
            return clientData;
        }
        WorldData worldData = WorldData.get(player.m_20193_());
        ConcurrentHashMap<UUID, PlayerSave> data = worldData.playerSaveData;
        UUID id = player.m_20148_();
        if (data.containsKey(id) && (save = data.get(id)) != null && save.id != null && save.id.equals(id)) {
            return save;
        }
        save = new PlayerSave(id);
        data.put(id, save);
        worldData.m_77762_();
        return save;
    }

    public static class PlayerSave {
        public UUID id;
        public boolean bookGottenAlready;
        public boolean didBookTutorial;
        public boolean hasBatWings;
        public boolean shouldDisableBatWings;
        public int batWingsFlyTime;
        public IBookletPage[] bookmarks = new IBookletPage[12];
        public List<String> completedTrials = new ArrayList<String>();

        public PlayerSave(UUID id) {
            this.id = id;
        }

        public void readFromNBT(CompoundTag compound, boolean savingToFile) {
            this.bookGottenAlready = compound.m_128471_("BookGotten");
            this.didBookTutorial = compound.m_128471_("DidTutorial");
            this.hasBatWings = compound.m_128471_("HasBatWings");
            this.batWingsFlyTime = compound.m_128451_("BatWingsFlyTime");
            ListTag bookmarks = compound.m_128437_("Bookmarks", 8);
            this.loadBookmarks(bookmarks);
            ListTag trials = compound.m_128437_("Trials", 8);
            this.loadTrials(trials);
            if (!savingToFile) {
                this.shouldDisableBatWings = compound.m_128471_("ShouldDisableWings");
            }
        }

        public void writeToNBT(CompoundTag compound, boolean savingToFile) {
            compound.m_128379_("BookGotten", this.bookGottenAlready);
            compound.m_128379_("DidTutorial", this.didBookTutorial);
            compound.m_128379_("HasBatWings", this.hasBatWings);
            compound.m_128405_("BatWingsFlyTime", this.batWingsFlyTime);
            compound.m_128365_("Bookmarks", (Tag)this.saveBookmarks());
            compound.m_128365_("Trials", (Tag)this.saveTrials());
            if (!savingToFile) {
                compound.m_128379_("ShouldDisableWings", this.shouldDisableBatWings);
            }
        }

        public ListTag saveBookmarks() {
            ListTag bookmarks = new ListTag();
            for (IBookletPage bookmark : this.bookmarks) {
                bookmarks.add((Object)StringTag.m_129297_((String)(bookmark == null ? "" : bookmark.getIdentifier())));
            }
            return bookmarks;
        }

        public void loadBookmarks(ListTag bookmarks) {
            for (int i = 0; i < bookmarks.size(); ++i) {
                String strg = bookmarks.m_128778_(i);
                this.bookmarks[i] = !strg.isEmpty() ? null : null;
            }
        }

        public ListTag saveTrials() {
            ListTag trials = new ListTag();
            for (String trial : this.completedTrials) {
                trials.add((Object)StringTag.m_129297_((String)trial));
            }
            return trials;
        }

        public void loadTrials(ListTag trials) {
            this.completedTrials.clear();
            for (int i = 0; i < trials.size(); ++i) {
                String strg = trials.m_128778_(i);
                if (strg.isEmpty()) continue;
                this.completedTrials.add(strg);
            }
        }
    }
}

