/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.crafting;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.IIngredientSerializer;

public class TargetNBTIngredient
extends Ingredient {
    public static Serializer SERIALIZER = new Serializer();

    public TargetNBTIngredient(Stream<? extends Ingredient.Value> itemLists) {
        super(itemLists);
    }

    @Nonnull
    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return SERIALIZER;
    }

    public static TargetNBTIngredient of(ItemLike itemProvider) {
        return new TargetNBTIngredient(Stream.of(new Ingredient.ItemValue(new ItemStack(itemProvider))));
    }

    public static TargetNBTIngredient of(ItemStack itemStack) {
        return new TargetNBTIngredient(Stream.of(new Ingredient.ItemValue(itemStack)));
    }

    @Nonnull
    public static TargetNBTIngredient of(@Nonnull TagKey<Item> tag) {
        return new TargetNBTIngredient(Stream.of(new Ingredient.TagValue(tag)));
    }

    @Nonnull
    public JsonElement m_43942_() {
        JsonObject tmp = super.m_43942_().getAsJsonObject();
        tmp.addProperty("type", Serializer.NAME.toString());
        return tmp;
    }

    public static class Serializer
    implements IIngredientSerializer<TargetNBTIngredient> {
        public static ResourceLocation NAME = new ResourceLocation("actuallyadditions", "nbt_target");

        @Nonnull
        public TargetNBTIngredient parse(FriendlyByteBuf buffer) {
            return new TargetNBTIngredient(Stream.generate(() -> new Ingredient.ItemValue(buffer.m_130267_())).limit(buffer.m_130242_()));
        }

        @Nonnull
        public TargetNBTIngredient parse(@Nonnull JsonObject json) {
            return new TargetNBTIngredient(Stream.of(Ingredient.m_43919_((JsonObject)json)));
        }

        public void write(FriendlyByteBuf buffer, TargetNBTIngredient ingredient) {
            ItemStack[] items = ingredient.m_43908_();
            buffer.m_130130_(items.length);
            for (ItemStack stack : items) {
                buffer.m_130055_(stack);
            }
        }
    }
}

