/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.crafting;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.ellpeck.actuallyadditions.mod.crafting.ActuallyRecipes;
import de.ellpeck.actuallyadditions.mod.crafting.SingleItem;
import javax.annotation.Nullable;
import net.minecraft.core.RegistryAccess;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class SolidFuelRecipe
implements Recipe<SingleItem> {
    public static String NAME = "solid_fuel";
    private Ingredient itemIngredient;
    private int burnTime;
    private int totalEnergy;
    private ResourceLocation id;

    public SolidFuelRecipe(ResourceLocation id, Ingredient itemIngredient, int totalEnergy, int burnTime) {
        this.itemIngredient = itemIngredient;
        this.burnTime = burnTime;
        this.totalEnergy = totalEnergy;
        this.id = id;
    }

    public int getBurnTime() {
        return this.burnTime;
    }

    public int getTotalEnergy() {
        return this.totalEnergy;
    }

    public boolean matches(SingleItem pInv, Level pLevel) {
        return this.itemIngredient.test(pInv.getItem());
    }

    public boolean matches(ItemStack stack) {
        return this.itemIngredient.test(stack);
    }

    public boolean m_5598_() {
        return true;
    }

    public ItemStack assemble(SingleItem pInv, RegistryAccess registryAccess) {
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int pWidth, int pHeight) {
        return false;
    }

    public ItemStack m_8043_(RegistryAccess pRegistryAccess) {
        return ItemStack.f_41583_;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ActuallyRecipes.SOLID_FUEL_RECIPE.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)ActuallyRecipes.Types.SOLID_FUEL.get();
    }

    public static class Result
    implements FinishedRecipe {
        private Ingredient itemIngredient;
        private int burnTime;
        private int totalEnergy;
        private ResourceLocation id;

        public Result(ResourceLocation id, Ingredient itemIngredient, int totalEnergy, int burnTime) {
            this.itemIngredient = itemIngredient;
            this.burnTime = burnTime;
            this.totalEnergy = totalEnergy;
            this.id = id;
        }

        public void m_7917_(JsonObject pJson) {
            pJson.add("item", this.itemIngredient.m_43942_());
            pJson.addProperty("total_energy", (Number)this.totalEnergy);
            pJson.addProperty("burn_time", (Number)this.burnTime);
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)ActuallyRecipes.SOLID_FUEL_RECIPE.get();
        }

        @Nullable
        public JsonObject m_5860_() {
            return null;
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return null;
        }
    }

    public static class Serializer
    implements RecipeSerializer<SolidFuelRecipe> {
        public SolidFuelRecipe fromJson(ResourceLocation pId, JsonObject pJson) {
            Ingredient itemIngredient = Ingredient.m_43917_((JsonElement)pJson.get("item"));
            int totalEnergy = pJson.get("total_energy").getAsInt();
            int burnTime = pJson.get("burn_time").getAsInt();
            return new SolidFuelRecipe(pId, itemIngredient, totalEnergy, burnTime);
        }

        public SolidFuelRecipe fromNetwork(ResourceLocation pId, FriendlyByteBuf pBuffer) {
            Ingredient itemIngredient = Ingredient.m_43940_((FriendlyByteBuf)pBuffer);
            int totalEnergy = pBuffer.readInt();
            int burnTime = pBuffer.readInt();
            return new SolidFuelRecipe(pId, itemIngredient, totalEnergy, burnTime);
        }

        public void toNetwork(FriendlyByteBuf pBuffer, SolidFuelRecipe pRecipe) {
            pRecipe.itemIngredient.m_43923_(pBuffer);
            pBuffer.writeInt(pRecipe.totalEnergy);
            pBuffer.writeInt(pRecipe.burnTime);
        }
    }
}

