/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.crafting;

import com.google.gson.JsonObject;
import de.ellpeck.actuallyadditions.mod.ActuallyAdditions;
import de.ellpeck.actuallyadditions.mod.crafting.ActuallyRecipes;
import de.ellpeck.actuallyadditions.mod.crafting.TargetNBTIngredient;
import java.util.Objects;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import org.jetbrains.annotations.Nullable;

public class RecipeKeepDataShapeless
extends ShapelessRecipe {
    public static String NAME = "copy_nbt_shapeless";

    public RecipeKeepDataShapeless(ResourceLocation id, String pGroup, CraftingBookCategory pCategory, ItemStack pResult, NonNullList<Ingredient> pIngredients) {
        super(id, pGroup, pCategory, pResult, pIngredients);
    }

    public RecipeKeepDataShapeless(ResourceLocation id, ShapelessRecipe recipe) {
        super(id, recipe.m_6076_(), recipe.m_245232_(), recipe.m_8043_((RegistryAccess)RegistryAccess.f_243945_), recipe.m_7527_());
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ActuallyRecipes.KEEP_DATA_SHAPELESS_RECIPE.get();
    }

    public ItemStack m_5874_(CraftingContainer pContainer, RegistryAccess pRegistryAccess) {
        ItemStack result = super.m_5874_(pContainer, pRegistryAccess);
        TargetNBTIngredient donorIngredient = null;
        ItemStack datasource = ItemStack.f_41583_;
        NonNullList ingredients = this.m_7527_();
        for (Ingredient ingredient : ingredients) {
            if (!(ingredient instanceof TargetNBTIngredient)) continue;
            donorIngredient = (TargetNBTIngredient)ingredient;
            break;
        }
        if (donorIngredient != null && !pContainer.m_7983_()) {
            for (int i = 0; i < pContainer.m_6643_(); ++i) {
                ItemStack item = pContainer.m_8020_(i);
                if (item.m_41619_() || !donorIngredient.test(item)) continue;
                datasource = item;
                break;
            }
        }
        if (datasource.m_41619_() || !datasource.m_41782_()) {
            ActuallyAdditions.LOGGER.info("AA.KeepDataShapeless missing TargetNBTIngredient");
            return ItemStack.f_41583_;
        }
        result.m_41751_(datasource.m_41783_().m_6426_());
        return result;
    }

    public static class Result
    implements FinishedRecipe {
        private final ShapelessRecipeBuilder.Result inner;

        public Result(ShapelessRecipeBuilder.Result result) {
            this.inner = result;
        }

        public void m_7917_(JsonObject jsonObject) {
            this.inner.m_7917_(jsonObject);
        }

        public ResourceLocation m_6445_() {
            return this.inner.m_6445_();
        }

        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)ActuallyRecipes.KEEP_DATA_SHAPELESS_RECIPE.get();
        }

        @Nullable
        public JsonObject m_5860_() {
            return this.inner.m_5860_();
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return this.inner.m_6448_();
        }
    }

    public static class Serializer
    implements RecipeSerializer<RecipeKeepDataShapeless> {
        public RecipeKeepDataShapeless fromJson(ResourceLocation id, JsonObject jsonObject) {
            return new RecipeKeepDataShapeless(id, Objects.requireNonNull((ShapelessRecipe)RecipeSerializer.f_44077_.m_6729_(id, jsonObject)));
        }

        public RecipeKeepDataShapeless fromNetwork(ResourceLocation id, FriendlyByteBuf pBuffer) {
            return new RecipeKeepDataShapeless(id, Objects.requireNonNull((ShapelessRecipe)RecipeSerializer.f_44077_.m_8005_(id, pBuffer)));
        }

        public void toNetwork(FriendlyByteBuf pBuffer, RecipeKeepDataShapeless pRecipe) {
            try {
                RecipeSerializer.f_44077_.m_6178_(pBuffer, (Recipe)pRecipe);
            }
            catch (Exception e) {
                ActuallyAdditions.LOGGER.info("Failed to serialize " + NAME + " Recipe to packet: " + e.getMessage());
                throw e;
            }
        }
    }
}

