/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.crafting;

import com.google.gson.JsonObject;
import de.ellpeck.actuallyadditions.mod.crafting.ActuallyRecipes;
import de.ellpeck.actuallyadditions.mod.crafting.TargetNBTIngredient;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RecipeKeepDataShaped
extends ShapedRecipe {
    public static String NAME = "copy_nbt";
    public static final Logger LOGGER = LogManager.getLogger();

    public RecipeKeepDataShaped(ResourceLocation idIn, String groupIn, int recipeWidthIn, int recipeHeightIn, NonNullList<Ingredient> recipeItemsIn, ItemStack recipeOutputIn) {
        super(idIn, groupIn, CraftingBookCategory.MISC, recipeWidthIn, recipeHeightIn, recipeItemsIn, recipeOutputIn);
    }

    public RecipeKeepDataShaped(ShapedRecipe shapedRecipe) {
        super(shapedRecipe.m_6423_(), shapedRecipe.m_6076_(), CraftingBookCategory.MISC, shapedRecipe.getRecipeWidth(), shapedRecipe.getRecipeHeight(), shapedRecipe.m_7527_(), shapedRecipe.m_8043_(null));
    }

    public ItemStack m_5874_(CraftingContainer inv, RegistryAccess registryAccess) {
        ItemStack craftingResult = super.m_5874_(inv, registryAccess);
        TargetNBTIngredient donorIngredient = null;
        ItemStack datasource = ItemStack.f_41583_;
        NonNullList ingredients = this.m_7527_();
        for (Ingredient ingredient : ingredients) {
            if (!(ingredient instanceof TargetNBTIngredient)) continue;
            donorIngredient = (TargetNBTIngredient)ingredient;
            break;
        }
        if (donorIngredient != null && !inv.m_7983_()) {
            for (int i = 0; i < inv.m_6643_(); ++i) {
                ItemStack item = inv.m_8020_(i);
                if (item.m_41619_() || !donorIngredient.test(item)) continue;
                datasource = item;
                break;
            }
        }
        if (!datasource.m_41619_() && datasource.m_41782_()) {
            craftingResult.m_41751_(datasource.m_41783_().m_6426_());
        }
        return craftingResult;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ActuallyRecipes.KEEP_DATA_SHAPED_RECIPE.get();
    }

    public static class Serializer
    implements RecipeSerializer<RecipeKeepDataShaped> {
        @Nullable
        public RecipeKeepDataShaped fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            return new RecipeKeepDataShaped((ShapedRecipe)RecipeSerializer.f_44076_.m_8005_(recipeId, buffer));
        }

        public RecipeKeepDataShaped fromJson(ResourceLocation recipeId, JsonObject json) {
            try {
                return new RecipeKeepDataShaped((ShapedRecipe)RecipeSerializer.f_44076_.m_6729_(recipeId, json));
            }
            catch (Exception exception) {
                LOGGER.info("Error reading " + NAME + " Recipe from packet: ", (Throwable)exception);
                throw exception;
            }
        }

        public void toNetwork(FriendlyByteBuf buffer, RecipeKeepDataShaped recipe) {
            try {
                RecipeSerializer.f_44076_.m_6178_(buffer, (Recipe)recipe);
            }
            catch (Exception exception) {
                LOGGER.info("Error writing " + NAME + " Recipe to packet: ", (Throwable)exception);
                throw exception;
            }
        }
    }
}

