/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.crafting;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import de.ellpeck.actuallyadditions.mod.crafting.ActuallyRecipes;
import de.ellpeck.actuallyadditions.mod.util.GsonUtil;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.RegistryAccess;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;

public class PressingRecipe
implements Recipe<Container> {
    public static final String NAME = "pressing";
    private final ResourceLocation ID;
    private final Ingredient input;
    private final FluidStack output;

    public PressingRecipe(ResourceLocation ID, Ingredient input, FluidStack output) {
        this.ID = ID;
        this.input = input;
        this.output = output;
    }

    public boolean m_5818_(@Nonnull Container pInv, @Nullable Level pLevel) {
        return this.input.test(pInv.m_8020_(0));
    }

    public boolean m_5598_() {
        return true;
    }

    public Ingredient getInput() {
        return this.input;
    }

    public ItemStack m_5874_(Container pInv, RegistryAccess pRegistryAccess) {
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int pWidth, int pHeight) {
        return true;
    }

    public FluidStack getOutput() {
        return this.output;
    }

    public ItemStack m_8043_(RegistryAccess pRegistryAccess) {
        return ItemStack.f_41583_;
    }

    public ResourceLocation m_6423_() {
        return this.ID;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ActuallyRecipes.PRESSING_RECIPE.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)ActuallyRecipes.Types.PRESSING.get();
    }

    public static class Result
    implements FinishedRecipe {
        private final ResourceLocation ID;
        private final Ingredient input;
        private final FluidStack output;

        public Result(ResourceLocation ID, Ingredient input, FluidStack output) {
            this.ID = ID;
            this.input = input;
            this.output = output;
        }

        public void m_7917_(JsonObject pJson) {
            pJson.add("ingredient", this.input.m_43942_());
            GsonUtil.setFluidStack(pJson, "fluid", this.output);
        }

        public ResourceLocation m_6445_() {
            return this.ID;
        }

        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)ActuallyRecipes.PRESSING_RECIPE.get();
        }

        @Nullable
        public JsonObject m_5860_() {
            return null;
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return null;
        }
    }

    public static class Serializer
    implements RecipeSerializer<PressingRecipe> {
        @Nonnull
        public PressingRecipe fromJson(@Nonnull ResourceLocation pRecipeId, @Nonnull JsonObject pJson) {
            Ingredient ingredient = Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)pJson, (String)"ingredient"));
            FluidStack output = GsonUtil.getFluidStack(pJson, "fluid");
            return new PressingRecipe(pRecipeId, ingredient, output);
        }

        @Nullable
        public PressingRecipe fromNetwork(@Nonnull ResourceLocation pRecipeId, @Nonnull FriendlyByteBuf pBuffer) {
            Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)pBuffer);
            ResourceLocation fluidRes = new ResourceLocation(pBuffer.m_130277_());
            int fluidAmount = pBuffer.readInt();
            Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(fluidRes);
            if (fluid == null) {
                throw new JsonParseException("Unknown fluid '" + fluidRes + "'");
            }
            FluidStack output = new FluidStack(fluid, fluidAmount);
            return new PressingRecipe(pRecipeId, ingredient, output);
        }

        public void toNetwork(@Nonnull FriendlyByteBuf pBuffer, @Nonnull PressingRecipe pRecipe) {
            pRecipe.input.m_43923_(pBuffer);
            pBuffer.m_130070_(ForgeRegistries.FLUIDS.getKey((Object)pRecipe.output.getFluid()).toString());
            pBuffer.writeInt(pRecipe.output.getAmount());
        }
    }
}

