/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.crafting;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import de.ellpeck.actuallyadditions.mod.crafting.ActuallyRecipes;
import de.ellpeck.actuallyadditions.mod.util.GsonUtil;
import java.util.Locale;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.random.Weight;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class MiningLensRecipe
implements Recipe<Container>,
WeightedEntry {
    public static final String NAME = "mining_lens";
    private final ResourceLocation id;
    private final int weight;
    private final Ingredient input;
    private ItemStack output;
    private TagKey<Item> outputTag;
    private OutputType outputType;

    private MiningLensRecipe(ResourceLocation id, Ingredient input, int weight) {
        this.weight = weight;
        this.input = input;
        this.id = id;
    }

    public MiningLensRecipe(ResourceLocation id, Ingredient input, int weight, ItemStack output) {
        this(id, input, weight);
        this.output = output;
        this.outputType = OutputType.ITEM;
    }

    public MiningLensRecipe(ResourceLocation id, Ingredient input, int weight, TagKey<Item> outputTag) {
        this(id, input, weight);
        this.outputTag = outputTag;
        this.outputType = OutputType.TAG;
    }

    public Weight m_142631_() {
        return Weight.m_146282_((int)this.weight);
    }

    public Ingredient getInput() {
        return this.input;
    }

    public boolean matches(ItemStack test) {
        return this.input.test(test);
    }

    public boolean m_5818_(Container pInv, Level pLevel) {
        return false;
    }

    public boolean m_5598_() {
        return true;
    }

    @Nonnull
    public ItemStack m_5874_(Container pInv, RegistryAccess pRegistryAccess) {
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int pWidth, int pHeight) {
        return false;
    }

    @NotNull
    public ItemStack m_8043_(RegistryAccess pRegistryAccess) {
        if (this.outputType == OutputType.ITEM) {
            return this.output;
        }
        return this.getOutputTag().map(x -> new ItemStack((ItemLike)x.m_203662_(0).get())).orElse(ItemStack.f_41583_);
    }

    private Optional<HolderSet.Named<Item>> getOutputTag() {
        if (this.outputType == OutputType.ITEM) {
            return Optional.empty();
        }
        return BuiltInRegistries.f_257033_.m_203431_(this.outputTag);
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ActuallyRecipes.MINING_LENS_RECIPE.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)ActuallyRecipes.Types.MINING_LENS.get();
    }

    public static enum OutputType {
        ITEM,
        TAG;

    }

    public static class Result
    implements FinishedRecipe {
        private final ResourceLocation id;
        private final Ingredient itemIngredient;
        private final int weight;
        private final ItemLike output;
        private final TagKey<Item> outputTag;
        private final OutputType outputType;

        public Result(ResourceLocation id, Ingredient itemIngredient, int weight, ItemLike output, TagKey<Item> outputTag, OutputType outputType) {
            this.id = id;
            this.itemIngredient = itemIngredient;
            this.weight = weight;
            this.output = output;
            this.outputTag = outputTag;
            this.outputType = outputType;
        }

        public void m_7917_(JsonObject pJson) {
            pJson.add("ingredient", this.itemIngredient.m_43942_());
            pJson.addProperty("weight", (Number)this.weight);
            pJson.addProperty("output_type", this.outputType.toString().toLowerCase(Locale.ROOT));
            if (this.outputType == OutputType.ITEM) {
                JsonObject resultObject = new JsonObject();
                resultObject.addProperty("item", ForgeRegistries.ITEMS.getKey((Object)this.output.m_5456_()).toString());
                pJson.add("result", (JsonElement)resultObject);
            } else if (this.outputType == OutputType.TAG) {
                pJson.add("result", (JsonElement)TagKey.m_203877_((ResourceKey)Registries.f_256913_).encodeStart((DynamicOps)JsonOps.INSTANCE, this.outputTag).getOrThrow(false, e -> {
                    throw new IllegalStateException((String)e);
                }));
            }
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)ActuallyRecipes.MINING_LENS_RECIPE.get();
        }

        @Nullable
        public JsonObject m_5860_() {
            return null;
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return null;
        }
    }

    public static class Serializer
    implements RecipeSerializer<MiningLensRecipe> {
        public MiningLensRecipe fromJson(@Nonnull ResourceLocation pRecipeId, @Nonnull JsonObject pJson) {
            Ingredient ingredient = Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)pJson, (String)"ingredient"));
            int weight = GsonHelper.m_13927_((JsonObject)pJson, (String)"weight");
            String type = GsonHelper.m_13851_((JsonObject)pJson, (String)"output_type", (String)"item");
            if (type.equals("item")) {
                ItemStack result = GsonUtil.getItemWithCount(pJson, "result");
                return new MiningLensRecipe(pRecipeId, ingredient, weight, result);
            }
            if (type.equals("tag")) {
                TagKey tag = (TagKey)((Pair)TagKey.m_203877_((ResourceKey)Registries.f_256913_).decode((DynamicOps)JsonOps.INSTANCE, (Object)pJson.get("result")).getOrThrow(false, e -> {
                    throw new IllegalStateException((String)e);
                })).getFirst();
                return new MiningLensRecipe(pRecipeId, ingredient, weight, (TagKey<Item>)tag);
            }
            throw new IllegalStateException("Unknown recipe type: " + type);
        }

        @Nullable
        public MiningLensRecipe fromNetwork(@Nonnull ResourceLocation pRecipeId, @Nonnull FriendlyByteBuf pBuffer) {
            Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)pBuffer);
            int weight = pBuffer.readInt();
            OutputType outputType = (OutputType)pBuffer.m_130066_(OutputType.class);
            if (outputType == OutputType.ITEM) {
                ItemStack result = pBuffer.m_130267_();
                return new MiningLensRecipe(pRecipeId, ingredient, weight, result);
            }
            if (outputType == OutputType.TAG) {
                TagKey tagKey = (TagKey)pBuffer.m_271872_(TagKey.m_203877_((ResourceKey)Registries.f_256913_));
                return new MiningLensRecipe(pRecipeId, ingredient, weight, (TagKey<Item>)tagKey);
            }
            throw new IllegalStateException("Invalid mining lens output type " + outputType);
        }

        public void toNetwork(@Nonnull FriendlyByteBuf pBuffer, MiningLensRecipe pRecipe) {
            pRecipe.input.m_43923_(pBuffer);
            pBuffer.writeInt(pRecipe.weight);
            pBuffer.m_130068_((Enum)pRecipe.outputType);
            if (pRecipe.outputType == OutputType.ITEM) {
                pBuffer.m_130055_(pRecipe.output);
            } else if (pRecipe.outputType == OutputType.TAG) {
                pBuffer.m_272073_(TagKey.m_203877_((ResourceKey)Registries.f_256913_), pRecipe.outputTag);
            }
        }
    }
}

