/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.crafting;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import de.ellpeck.actuallyadditions.mod.crafting.ActuallyRecipes;
import de.ellpeck.actuallyadditions.mod.util.GsonUtil;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.RegistryAccess;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;

public class LiquidFuelRecipe
implements Recipe<Container> {
    public static String NAME = "liquid_fuel";
    private FluidStack fuel;
    private int burnTime;
    private int totalEnergy;
    private ResourceLocation id;

    public LiquidFuelRecipe(ResourceLocation id, FluidStack fuel, int totalEnergy, int burnTime) {
        this.fuel = fuel;
        this.burnTime = burnTime;
        this.totalEnergy = totalEnergy;
        this.id = id;
    }

    public int getBurnTime() {
        return this.burnTime;
    }

    public int getTotalEnergy() {
        return this.totalEnergy;
    }

    public boolean m_5818_(@Nonnull Container pInv, @Nonnull Level pLevel) {
        return false;
    }

    public boolean matches(FluidStack stack) {
        return this.fuel.isFluidEqual(stack);
    }

    public boolean m_5598_() {
        return true;
    }

    public int getFuelAmount() {
        return this.fuel.getAmount();
    }

    public FluidStack getFuel() {
        return this.fuel;
    }

    @Nonnull
    public ItemStack m_5874_(Container pInv, RegistryAccess pRegistryAccess) {
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int pWidth, int pHeight) {
        return false;
    }

    @Nonnull
    public ItemStack m_8043_(RegistryAccess pRegistryAccess) {
        return ItemStack.f_41583_;
    }

    @Nonnull
    public ResourceLocation m_6423_() {
        return this.id;
    }

    @Nonnull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ActuallyRecipes.LIQUID_FUEL_RECIPE.get();
    }

    @Nonnull
    public RecipeType<?> m_6671_() {
        return (RecipeType)ActuallyRecipes.Types.LIQUID_FUEL.get();
    }

    public static class Result
    implements FinishedRecipe {
        private FluidStack fuel;
        private int burnTime;
        private int totalEnergy;
        private ResourceLocation id;

        public Result(ResourceLocation id, FluidStack fuel, int totalEnergy, int burnTime) {
            this.fuel = fuel;
            this.burnTime = burnTime;
            this.totalEnergy = totalEnergy;
            this.id = id;
        }

        public void m_7917_(JsonObject pJson) {
            JsonObject result = new JsonObject();
            result.addProperty("total_energy", (Number)this.totalEnergy);
            result.addProperty("burn_time", (Number)this.burnTime);
            GsonUtil.setFluidStack(pJson, "fuel", this.fuel);
            pJson.add("result", (JsonElement)result);
        }

        @Nonnull
        public ResourceLocation m_6445_() {
            return this.id;
        }

        @Nonnull
        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)ActuallyRecipes.LIQUID_FUEL_RECIPE.get();
        }

        @Nullable
        public JsonObject m_5860_() {
            return null;
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return null;
        }
    }

    public static class Serializer
    implements RecipeSerializer<LiquidFuelRecipe> {
        @Nonnull
        public LiquidFuelRecipe fromJson(@Nonnull ResourceLocation pId, JsonObject pJson) {
            FluidStack input = GsonUtil.getFluidStack(pJson, "fuel");
            JsonObject result = pJson.getAsJsonObject("result");
            int totalEnergy = result.get("total_energy").getAsInt();
            int burnTime = result.get("burn_time").getAsInt();
            return new LiquidFuelRecipe(pId, input, totalEnergy, burnTime);
        }

        public LiquidFuelRecipe fromNetwork(@Nonnull ResourceLocation pId, @Nonnull FriendlyByteBuf pBuffer) {
            ResourceLocation inputRes = new ResourceLocation(pBuffer.m_130277_());
            int inputAmount = pBuffer.readInt();
            Fluid inputFluid = (Fluid)ForgeRegistries.FLUIDS.getValue(inputRes);
            if (inputFluid == null) {
                throw new JsonParseException("Unknown input fluid '" + inputRes + "'");
            }
            FluidStack input = new FluidStack(inputFluid, inputAmount);
            int totalEnergy = pBuffer.readInt();
            int burnTime = pBuffer.readInt();
            return new LiquidFuelRecipe(pId, input, totalEnergy, burnTime);
        }

        public void toNetwork(@Nonnull FriendlyByteBuf pBuffer, LiquidFuelRecipe pRecipe) {
            pBuffer.m_130070_(ForgeRegistries.FLUIDS.getKey((Object)pRecipe.fuel.getFluid()).toString());
            pBuffer.writeInt(pRecipe.fuel.getAmount());
            pBuffer.writeInt(pRecipe.totalEnergy);
            pBuffer.writeInt(pRecipe.burnTime);
        }
    }
}

