/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.crafting;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.ellpeck.actuallyadditions.mod.ActuallyAdditions;
import de.ellpeck.actuallyadditions.mod.blocks.ActuallyBlocks;
import de.ellpeck.actuallyadditions.mod.crafting.ActuallyRecipes;
import de.ellpeck.actuallyadditions.mod.util.GsonUtil;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.RegistryAccess;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;

public class LaserRecipe
implements Recipe<Container> {
    public static String NAME = "laser";
    private ItemStack result;
    private Ingredient itemIngredient;
    private int energy;
    private ResourceLocation id;

    public LaserRecipe(ResourceLocation id, ItemStack result, Ingredient itemIngredient, int energy) {
        this.result = result;
        this.itemIngredient = itemIngredient;
        this.energy = energy;
        this.id = id;
    }

    public int getEnergy() {
        return this.energy;
    }

    public boolean matches(ItemStack itemStack, int energyIn) {
        return this.itemIngredient.test(itemStack) && energyIn >= this.energy;
    }

    public boolean matches(ItemStack itemStack) {
        return this.itemIngredient.test(itemStack);
    }

    public Ingredient getInput() {
        return this.itemIngredient;
    }

    public ItemStack m_8042_() {
        return new ItemStack((ItemLike)ActuallyBlocks.ATOMIC_RECONSTRUCTOR.get());
    }

    public boolean m_5818_(Container pInv, Level pLevel) {
        return false;
    }

    public boolean m_5598_() {
        return true;
    }

    public ItemStack m_5874_(Container pInv, RegistryAccess pRegistryAccess) {
        return this.result.m_41777_();
    }

    public boolean m_8004_(int pWidth, int pHeight) {
        return false;
    }

    public ItemStack m_8043_(RegistryAccess pRegistryAccess) {
        return this.result;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return ActuallyRecipes.LASER_RECIPE.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)ActuallyRecipes.Types.LASER.get();
    }

    public static Optional<LaserRecipe> getRecipeForStack(ItemStack stack) {
        return ActuallyAdditions.getRecipeManager().m_44013_((RecipeType)ActuallyRecipes.Types.LASER.get()).stream().filter(recipe -> recipe.matches(stack)).findFirst();
    }

    public boolean validInput(ItemStack stack) {
        return LaserRecipe.getRecipeForStack(stack).isPresent();
    }

    public static class Result
    implements FinishedRecipe {
        private ResourceLocation id;
        private Ingredient itemIngredient;
        private int energy;
        private ItemLike output;

        public Result(ResourceLocation id, Ingredient itemIngredient, int energy, ItemLike output) {
            this.id = id;
            this.itemIngredient = itemIngredient;
            this.energy = energy;
            this.output = output;
        }

        public void m_7917_(JsonObject pJson) {
            pJson.add("ingredient", this.itemIngredient.m_43942_());
            pJson.addProperty("energy", (Number)this.energy);
            JsonObject resultObject = new JsonObject();
            resultObject.addProperty("item", ForgeRegistries.ITEMS.getKey((Object)this.output.m_5456_()).toString());
            pJson.add("result", (JsonElement)resultObject);
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return ActuallyRecipes.LASER_RECIPE.get();
        }

        @Nullable
        public JsonObject m_5860_() {
            return null;
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return null;
        }
    }

    public static class Serializer
    implements RecipeSerializer<LaserRecipe> {
        public LaserRecipe fromJson(@Nonnull ResourceLocation pRecipeId, @Nonnull JsonObject pJson) {
            Ingredient ingredient = Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)pJson, (String)"ingredient"));
            int energy = GsonHelper.m_13927_((JsonObject)pJson, (String)"energy");
            ItemStack result = GsonUtil.getItemWithCount(pJson, "result");
            return new LaserRecipe(pRecipeId, result, ingredient, energy);
        }

        @Nullable
        public LaserRecipe fromNetwork(@Nonnull ResourceLocation pRecipeId, @Nonnull FriendlyByteBuf pBuffer) {
            Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)pBuffer);
            int energy = pBuffer.readInt();
            ItemStack result = pBuffer.m_130267_();
            return new LaserRecipe(pRecipeId, result, ingredient, energy);
        }

        public void toNetwork(@Nonnull FriendlyByteBuf pBuffer, LaserRecipe pRecipe) {
            pRecipe.itemIngredient.m_43923_(pBuffer);
            pBuffer.writeInt(pRecipe.energy);
            pBuffer.m_130055_(pRecipe.result);
        }
    }
}

