/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.crafting;

import com.google.gson.JsonObject;
import de.ellpeck.actuallyadditions.mod.crafting.ActuallyRecipes;
import de.ellpeck.actuallyadditions.mod.inventory.gui.FluidDisplay;
import de.ellpeck.actuallyadditions.mod.util.GsonUtil;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.RegistryAccess;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;

public class FermentingRecipe
implements Recipe<Container> {
    public static final String NAME = "fermenting";
    private final ResourceLocation ID;
    private final FluidStack input;
    private final FluidStack output;
    private final int time;
    private Optional<FluidDisplay> inputDisplay;
    private Optional<FluidDisplay> outputDisplay;

    public FermentingRecipe(ResourceLocation ID, FluidStack input, FluidStack output, int timeIn) {
        this.ID = ID;
        this.input = input;
        this.output = output;
        this.time = timeIn;
    }

    public boolean matches(FluidStack stack) {
        return stack.isFluidEqual(this.input);
    }

    public boolean matches(FluidStack input, FluidStack output) {
        return input.isFluidEqual(this.input) && (output.isEmpty() || output.isFluidEqual(this.output) && input.getAmount() >= this.input.getAmount());
    }

    public Optional<FluidDisplay> getInputDisplay() {
        return this.inputDisplay;
    }

    public void setInputDisplay(FluidDisplay inputDisplay) {
        this.inputDisplay = Optional.of(inputDisplay);
    }

    public Optional<FluidDisplay> getOutputDisplay() {
        return this.outputDisplay;
    }

    public void setOutputDisplay(FluidDisplay outputDisplay) {
        this.outputDisplay = Optional.of(outputDisplay);
    }

    public int getTime() {
        return this.time;
    }

    public FluidStack getOutput() {
        return this.output;
    }

    public FluidStack getInput() {
        return this.input;
    }

    public boolean m_5818_(Container pInv, Level pLevel) {
        return false;
    }

    public boolean m_5598_() {
        return true;
    }

    @Nonnull
    public ItemStack m_5874_(Container pInv, RegistryAccess pRegistryAccess) {
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int pWidth, int pHeight) {
        return false;
    }

    @Nonnull
    public ItemStack m_8043_(RegistryAccess pRegistryAccess) {
        return ItemStack.f_41583_;
    }

    @Nonnull
    public ResourceLocation m_6423_() {
        return this.ID;
    }

    @Nonnull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ActuallyRecipes.FERMENTING_RECIPE.get();
    }

    @Nonnull
    public RecipeType<?> m_6671_() {
        return (RecipeType)ActuallyRecipes.Types.FERMENTING.get();
    }

    public static class Result
    implements FinishedRecipe {
        private final ResourceLocation ID;
        private final FluidStack input;
        private final FluidStack output;
        private final int time;

        public Result(ResourceLocation ID, FluidStack input, FluidStack output, int timeIn) {
            this.ID = ID;
            this.input = input;
            this.output = output;
            this.time = timeIn;
        }

        public void m_7917_(JsonObject pJson) {
            GsonUtil.setFluidStack(pJson, "ingredient", this.input);
            GsonUtil.setFluidStack(pJson, "result", this.output);
            pJson.addProperty("time", (Number)this.time);
        }

        public ResourceLocation m_6445_() {
            return this.ID;
        }

        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)ActuallyRecipes.FERMENTING_RECIPE.get();
        }

        @Nullable
        public JsonObject m_5860_() {
            return null;
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return null;
        }
    }

    public static class Serializer
    implements RecipeSerializer<FermentingRecipe> {
        @Nonnull
        public FermentingRecipe fromJson(@Nonnull ResourceLocation pRecipeId, @Nonnull JsonObject pJson) {
            FluidStack input = GsonUtil.getFluidStack(pJson, "ingredient");
            FluidStack output = GsonUtil.getFluidStack(pJson, "result");
            int time = GsonHelper.m_13824_((JsonObject)pJson, (String)"time", (int)100);
            return new FermentingRecipe(pRecipeId, input, output, time);
        }

        @Nullable
        public FermentingRecipe fromNetwork(@Nonnull ResourceLocation pRecipeId, @Nonnull FriendlyByteBuf pBuffer) {
            FluidStack input = FluidStack.readFromPacket((FriendlyByteBuf)pBuffer);
            FluidStack output = FluidStack.readFromPacket((FriendlyByteBuf)pBuffer);
            int time = pBuffer.readInt();
            return new FermentingRecipe(pRecipeId, input, output, time);
        }

        public void toNetwork(@Nonnull FriendlyByteBuf pBuffer, @Nonnull FermentingRecipe pRecipe) {
            pRecipe.input.writeToPacket(pBuffer);
            pRecipe.output.writeToPacket(pBuffer);
            pBuffer.writeInt(pRecipe.time);
        }
    }
}

