/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.crafting;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.ellpeck.actuallyadditions.mod.crafting.ActuallyRecipes;
import de.ellpeck.actuallyadditions.mod.util.GsonUtil;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.RegistryAccess;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;

public class EmpowererRecipe
implements Recipe<Container> {
    public static String NAME = "empowering";
    private final ResourceLocation id;
    protected final Ingredient input;
    protected final ItemStack output;
    protected final Ingredient modifier1;
    protected final Ingredient modifier2;
    protected final Ingredient modifier3;
    protected final Ingredient modifier4;
    protected final int energyPerStand;
    protected final int particleColor;
    protected final int time;

    public EmpowererRecipe(ResourceLocation id, ItemStack output, Ingredient input, Ingredient modifier1, Ingredient modifier2, Ingredient modifier3, Ingredient modifier4, int energyPerStand, int particleColor, int time) {
        this.id = id;
        this.input = input;
        this.output = output;
        this.modifier1 = modifier1;
        this.modifier2 = modifier2;
        this.modifier3 = modifier3;
        this.modifier4 = modifier4;
        this.energyPerStand = energyPerStand;
        this.particleColor = particleColor;
        this.time = time;
    }

    public boolean matches(ItemStack base, ItemStack stand1, ItemStack stand2, ItemStack stand3, ItemStack stand4) {
        if (!this.input.test(base) || stand1.m_41619_() || stand2.m_41619_() || stand3.m_41619_() || stand4.m_41619_()) {
            return false;
        }
        ArrayList<Ingredient> matches = new ArrayList<Ingredient>();
        ItemStack[] stacks = new ItemStack[]{stand1, stand2, stand3, stand4};
        boolean[] unused = new boolean[]{true, true, true, true};
        for (ItemStack s : stacks) {
            if (unused[0] && this.modifier1.test(s)) {
                matches.add(this.modifier1);
                unused[0] = false;
                continue;
            }
            if (unused[1] && this.modifier2.test(s)) {
                matches.add(this.modifier2);
                unused[1] = false;
                continue;
            }
            if (unused[2] && this.modifier3.test(s)) {
                matches.add(this.modifier3);
                unused[2] = false;
                continue;
            }
            if (!unused[3] || !this.modifier4.test(s)) continue;
            matches.add(this.modifier4);
            unused[3] = false;
        }
        return matches.size() == 4;
    }

    public boolean m_5818_(@Nonnull Container pInv, @Nonnull Level pLevel) {
        return false;
    }

    public boolean m_5598_() {
        return true;
    }

    @Nonnull
    public ItemStack m_5874_(Container pInv, RegistryAccess pRegistryAccess) {
        return this.output.m_41777_();
    }

    public boolean m_8004_(int pWidth, int pHeight) {
        return false;
    }

    @Nonnull
    public ItemStack m_8043_(RegistryAccess pRegistryAccess) {
        return this.output;
    }

    @Nonnull
    public ResourceLocation m_6423_() {
        return this.id;
    }

    @Nonnull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ActuallyRecipes.EMPOWERING_RECIPE.get();
    }

    @Nonnull
    public RecipeType<?> m_6671_() {
        return (RecipeType)ActuallyRecipes.Types.EMPOWERING.get();
    }

    public Ingredient getInput() {
        return this.input;
    }

    public ItemStack getOutput() {
        return this.output;
    }

    public Ingredient getStandOne() {
        return this.modifier1;
    }

    public Ingredient getStandTwo() {
        return this.modifier2;
    }

    public Ingredient getStandThree() {
        return this.modifier3;
    }

    public Ingredient getStandFour() {
        return this.modifier4;
    }

    public int getTime() {
        return this.time;
    }

    public int getEnergyPerStand() {
        return this.energyPerStand;
    }

    public int getParticleColors() {
        return this.particleColor;
    }

    public static class Result
    implements FinishedRecipe {
        private final ResourceLocation id;
        private final Ingredient base;
        private final Ingredient mod1;
        private final Ingredient mod2;
        private final Ingredient mod3;
        private final Ingredient mod4;
        private final int energy;
        private final int color;
        private final int time;
        private final ItemLike output;

        public Result(ResourceLocation id, ItemLike output, Ingredient input, Ingredient modifier1, Ingredient modifier2, Ingredient modifier3, Ingredient modifier4, int energyPerStand, int particleColor, int time) {
            this.id = id;
            this.base = input;
            this.output = output;
            this.mod1 = modifier1;
            this.mod2 = modifier2;
            this.mod3 = modifier3;
            this.mod4 = modifier4;
            this.energy = energyPerStand;
            this.color = particleColor;
            this.time = time;
        }

        public void m_7917_(JsonObject pJson) {
            pJson.add("base", this.base.m_43942_());
            JsonArray modifiers = new JsonArray();
            modifiers.add(this.mod1.m_43942_());
            modifiers.add(this.mod2.m_43942_());
            modifiers.add(this.mod3.m_43942_());
            modifiers.add(this.mod4.m_43942_());
            pJson.add("modifiers", (JsonElement)modifiers);
            pJson.addProperty("energy", (Number)this.energy);
            pJson.addProperty("time", (Number)this.time);
            pJson.addProperty("color", (Number)this.color);
            JsonObject resultObject = new JsonObject();
            resultObject.addProperty("item", ForgeRegistries.ITEMS.getKey((Object)this.output.m_5456_()).toString());
            pJson.add("result", (JsonElement)resultObject);
        }

        @Nonnull
        public ResourceLocation m_6445_() {
            return this.id;
        }

        @Nonnull
        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)ActuallyRecipes.EMPOWERING_RECIPE.get();
        }

        @Nullable
        public JsonObject m_5860_() {
            return null;
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return null;
        }
    }

    public static class Serializer
    implements RecipeSerializer<EmpowererRecipe> {
        @Nonnull
        public EmpowererRecipe fromJson(@Nonnull ResourceLocation pRecipeId, @Nonnull JsonObject pJson) {
            Ingredient base = Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)pJson, (String)"base"));
            JsonArray modifiers = GsonHelper.m_13933_((JsonObject)pJson, (String)"modifiers");
            if (modifiers.size() != 4) {
                throw new IllegalStateException(pRecipeId.toString() + ": Must have exactly 4 modifiers, has: " + modifiers.size());
            }
            Ingredient mod1 = Ingredient.m_43917_((JsonElement)modifiers.get(0));
            Ingredient mod2 = Ingredient.m_43917_((JsonElement)modifiers.get(1));
            Ingredient mod3 = Ingredient.m_43917_((JsonElement)modifiers.get(2));
            Ingredient mod4 = Ingredient.m_43917_((JsonElement)modifiers.get(3));
            int energy = GsonHelper.m_13927_((JsonObject)pJson, (String)"energy");
            int color = GsonHelper.m_13927_((JsonObject)pJson, (String)"color");
            int time = GsonHelper.m_13927_((JsonObject)pJson, (String)"time");
            ItemStack result = GsonUtil.getItemWithCount(pJson, "result");
            return new EmpowererRecipe(pRecipeId, result, base, mod1, mod2, mod3, mod4, energy, color, time);
        }

        @Nullable
        public EmpowererRecipe fromNetwork(@Nonnull ResourceLocation pRecipeId, FriendlyByteBuf pBuffer) {
            ItemStack result = pBuffer.m_130267_();
            Ingredient input = Ingredient.m_43940_((FriendlyByteBuf)pBuffer);
            Ingredient mod1 = Ingredient.m_43940_((FriendlyByteBuf)pBuffer);
            Ingredient mod2 = Ingredient.m_43940_((FriendlyByteBuf)pBuffer);
            Ingredient mod3 = Ingredient.m_43940_((FriendlyByteBuf)pBuffer);
            Ingredient mod4 = Ingredient.m_43940_((FriendlyByteBuf)pBuffer);
            int energy = pBuffer.readInt();
            int color = pBuffer.readInt();
            int time = pBuffer.readInt();
            return new EmpowererRecipe(pRecipeId, result, input, mod1, mod2, mod3, mod4, energy, color, time);
        }

        public void toNetwork(FriendlyByteBuf pBuffer, EmpowererRecipe pRecipe) {
            pBuffer.m_130055_(pRecipe.output);
            pRecipe.input.m_43923_(pBuffer);
            pRecipe.modifier1.m_43923_(pBuffer);
            pRecipe.modifier2.m_43923_(pBuffer);
            pRecipe.modifier3.m_43923_(pBuffer);
            pRecipe.modifier4.m_43923_(pBuffer);
            pBuffer.writeInt(pRecipe.energyPerStand);
            pBuffer.writeInt(pRecipe.particleColor);
            pBuffer.writeInt(pRecipe.time);
        }
    }
}

