/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.crafting;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import de.ellpeck.actuallyadditions.mod.crafting.ActuallyRecipes;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class CrushingRecipe
implements Recipe<Container> {
    public static String NAME = "crushing";
    protected Ingredient input;
    protected NonNullList<CrushingResult> outputs;
    private final ResourceLocation id;

    public CrushingRecipe(ResourceLocation id, Ingredient input, NonNullList<CrushingResult> outputList) {
        this.id = id;
        this.input = input;
        this.outputs = outputList;
    }

    public CrushingRecipe(ResourceLocation id, Ingredient input, ItemStack outputOne, float chance1, ItemStack outputTwo, float chance2) {
        this(id, input, CrushingRecipe.createList(new CrushingResult(outputOne, chance1), new CrushingResult(outputTwo, chance2)));
    }

    @NotNull
    public ResourceLocation m_6423_() {
        return this.id;
    }

    private static NonNullList<CrushingResult> createList(CrushingResult ... results) {
        NonNullList list = NonNullList.m_122779_();
        for (CrushingResult result : results) {
            list.add((Object)result);
        }
        return list;
    }

    public boolean m_5818_(Container pInv, Level pLevel) {
        return this.input.test(pInv.m_8020_(0));
    }

    public boolean matches(ItemStack stack) {
        return this.input.test(stack);
    }

    public boolean m_5598_() {
        return true;
    }

    @Nonnull
    public ItemStack m_5874_(Container pInv, RegistryAccess pRegistryAccess) {
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int pWidth, int pHeight) {
        return true;
    }

    @Nonnull
    public ItemStack m_8043_(RegistryAccess pRegistryAccess) {
        return ((CrushingResult)this.outputs.get((int)0)).stack.m_41777_();
    }

    @Nonnull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ActuallyRecipes.CRUSHING_RECIPE.get();
    }

    @Nonnull
    public RecipeType<?> m_6671_() {
        return (RecipeType)ActuallyRecipes.Types.CRUSHING.get();
    }

    public ItemStack getOutputOne() {
        return ((CrushingResult)this.outputs.get((int)0)).stack;
    }

    public ItemStack getOutputTwo() {
        return this.outputs.size() == 1 ? ItemStack.f_41583_ : ((CrushingResult)this.outputs.get((int)1)).stack;
    }

    public float getFirstChance() {
        return ((CrushingResult)this.outputs.get((int)0)).chance;
    }

    public float getSecondChance() {
        return this.outputs.size() == 1 ? 0.0f : ((CrushingResult)this.outputs.get((int)1)).chance;
    }

    public Ingredient getInput() {
        return this.input;
    }

    public record CrushingResult(ItemStack stack, float chance) {
        public static final CrushingResult EMPTY = new CrushingResult(ItemStack.f_41583_, 0.0f);
    }

    public static class Result
    implements FinishedRecipe {
        public static String NAME = "crushing";
        protected Ingredient input;
        protected NonNullList<CrushingResult> outputs;
        private final ResourceLocation id;

        public Result(ResourceLocation id, Ingredient input, NonNullList<CrushingResult> outputList) {
            this.id = id;
            this.input = input;
            this.outputs = outputList;
        }

        public void m_7917_(JsonObject pJson) {
            pJson.add("ingredient", this.input.m_43942_());
            JsonArray results = new JsonArray();
            for (CrushingResult result : this.outputs) {
                JsonObject resultJson = new JsonObject();
                resultJson.add("result", (JsonElement)ItemStack.f_41582_.encode((Object)result.stack(), (DynamicOps)JsonOps.INSTANCE, (Object)JsonOps.INSTANCE.empty()).getOrThrow(false, e -> {
                    throw new IllegalStateException((String)e);
                }));
                resultJson.addProperty("chance", (Number)Float.valueOf(result.chance));
                results.add((JsonElement)resultJson);
            }
            pJson.add("result", (JsonElement)results);
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)ActuallyRecipes.CRUSHING_RECIPE.get();
        }

        @Nullable
        public JsonObject m_5860_() {
            return null;
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return null;
        }
    }

    public static class Serializer
    implements RecipeSerializer<CrushingRecipe> {
        @Nonnull
        public CrushingRecipe fromJson(@Nonnull ResourceLocation pRecipeId, @Nonnull JsonObject pJson) {
            Ingredient ingredient = Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)pJson, (String)"ingredient"));
            JsonArray resultList = GsonHelper.m_13933_((JsonObject)pJson, (String)"result");
            if (resultList.isEmpty()) {
                throw new IllegalStateException(pRecipeId.toString() + ": Recipe must contain at least 1 result item");
            }
            NonNullList results = NonNullList.m_122779_();
            resultList.asList().stream().map(x -> new CrushingResult((ItemStack)((Pair)ItemStack.f_41582_.decode((DynamicOps)JsonOps.INSTANCE, (Object)GsonHelper.m_13930_((JsonObject)x.getAsJsonObject(), (String)"result")).getOrThrow(false, e -> {
                throw new IllegalStateException((String)e);
            })).getFirst(), GsonHelper.m_13820_((JsonObject)x.getAsJsonObject(), (String)"chance", (float)1.0f))).forEach(arg_0 -> results.add(arg_0));
            return new CrushingRecipe(pRecipeId, ingredient, (NonNullList<CrushingResult>)results);
        }

        public CrushingRecipe fromNetwork(@NotNull ResourceLocation id, @Nonnull FriendlyByteBuf pBuffer) {
            Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)pBuffer);
            int i = pBuffer.m_130242_();
            NonNullList nonnulllist = NonNullList.m_122780_((int)i, (Object)CrushingResult.EMPTY);
            for (int j = 0; j < nonnulllist.size(); ++j) {
                nonnulllist.set(j, (Object)new CrushingResult(pBuffer.m_130267_(), pBuffer.readFloat()));
            }
            return new CrushingRecipe(id, ingredient, (NonNullList<CrushingResult>)nonnulllist);
        }

        public void toNetwork(@Nonnull FriendlyByteBuf pBuffer, CrushingRecipe pRecipe) {
            pRecipe.input.m_43923_(pBuffer);
            pBuffer.m_130130_(pRecipe.outputs.size());
            for (CrushingResult result : pRecipe.outputs) {
                pBuffer.m_130055_(result.stack);
                pBuffer.writeFloat(result.chance);
            }
        }
    }
}

