/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.crafting;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.ellpeck.actuallyadditions.mod.ActuallyAdditions;
import de.ellpeck.actuallyadditions.mod.crafting.ActuallyRecipes;
import de.ellpeck.actuallyadditions.mod.util.GsonUtil;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.RegistryAccess;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;

public class ColorChangeRecipe
implements Recipe<Container> {
    public static final String NAME = "color_change";
    private final Ingredient input;
    private final ItemStack output;
    private final ResourceLocation id;

    public ColorChangeRecipe(ResourceLocation id, ItemStack output, Ingredient input) {
        this.input = input;
        this.output = output;
        this.id = id;
    }

    public boolean m_5818_(@Nonnull Container pInv, @Nonnull Level pLevel) {
        return this.input.test(pInv.m_8020_(0));
    }

    public boolean matches(ItemStack stack) {
        return this.input.test(stack);
    }

    public boolean m_5598_() {
        return true;
    }

    @Nonnull
    public ItemStack m_5874_(Container pInv, RegistryAccess pRegistryAccess) {
        return this.output.m_41777_();
    }

    public boolean m_8004_(int pWidth, int pHeight) {
        return false;
    }

    public static Optional<ColorChangeRecipe> getRecipeForStack(ItemStack stack) {
        return ActuallyAdditions.getRecipeManager().m_44013_((RecipeType)ActuallyRecipes.Types.COLOR_CHANGE.get()).stream().filter(recipe -> recipe.matches(stack)).findFirst();
    }

    @Nonnull
    public ItemStack m_8043_(RegistryAccess pRegistryAccess) {
        return this.output.m_41777_();
    }

    @Nonnull
    public ResourceLocation m_6423_() {
        return this.id;
    }

    @Nonnull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ActuallyRecipes.COLOR_CHANGE_RECIPE.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)ActuallyRecipes.Types.COLOR_CHANGE.get();
    }

    public static class Result
    implements FinishedRecipe {
        private final ResourceLocation id;
        private final Ingredient itemIngredient;
        private final ItemLike output;

        public Result(ResourceLocation id, Ingredient itemIngredient, ItemLike output) {
            this.id = id;
            this.itemIngredient = itemIngredient;
            this.output = output;
        }

        public void m_7917_(JsonObject pJson) {
            pJson.add("ingredient", this.itemIngredient.m_43942_());
            JsonObject resultObject = new JsonObject();
            resultObject.addProperty("item", ForgeRegistries.ITEMS.getKey((Object)this.output.m_5456_()).toString());
            pJson.add("result", (JsonElement)resultObject);
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)ActuallyRecipes.COLOR_CHANGE_RECIPE.get();
        }

        @Nullable
        public JsonObject m_5860_() {
            return null;
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return null;
        }
    }

    public static class Serializer
    implements RecipeSerializer<ColorChangeRecipe> {
        public ColorChangeRecipe fromJson(@Nonnull ResourceLocation pRecipeId, @Nonnull JsonObject pJson) {
            Ingredient ingredient = Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)pJson, (String)"ingredient"));
            ItemStack result = GsonUtil.getItemWithCount(pJson, "result");
            return new ColorChangeRecipe(pRecipeId, result, ingredient);
        }

        @Nullable
        public ColorChangeRecipe fromNetwork(@Nonnull ResourceLocation pRecipeId, @Nonnull FriendlyByteBuf pBuffer) {
            Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)pBuffer);
            ItemStack result = pBuffer.m_130267_();
            return new ColorChangeRecipe(pRecipeId, result, ingredient);
        }

        public void toNetwork(@Nonnull FriendlyByteBuf pBuffer, ColorChangeRecipe pRecipe) {
            pRecipe.input.m_43923_(pBuffer);
            pBuffer.m_130055_(pRecipe.output);
        }
    }
}

