/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.crafting;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.ellpeck.actuallyadditions.api.ActuallyAdditionsAPI;
import de.ellpeck.actuallyadditions.mod.crafting.ActuallyRecipes;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class CoffeeIngredientRecipe
implements Recipe<Container> {
    public static final String NAME = "coffee_ingredient";
    protected final Ingredient ingredient;
    protected final List<EffectInstance> instances;
    protected final List<MobEffectInstance> effects;
    protected final int maxAmplifier;
    protected final String extraText;
    private final ResourceLocation id;

    public CoffeeIngredientRecipe(ResourceLocation id, Ingredient ingredient, List<EffectInstance> effectInstances, int maxAmplifier, String extraText) {
        EffectInstance instance;
        MobEffect effect;
        this.id = id;
        this.ingredient = ingredient;
        this.maxAmplifier = maxAmplifier;
        this.instances = effectInstances;
        ArrayList<MobEffectInstance> instances = new ArrayList<MobEffectInstance>();
        Iterator<EffectInstance> iterator = effectInstances.iterator();
        while (iterator.hasNext() && (effect = (MobEffect)BuiltInRegistries.f_256974_.m_7745_((instance = iterator.next()).effect())) != null) {
            instances.add(new MobEffectInstance(effect, instance.duration, instance.amplifier));
        }
        this.effects = instances;
        this.extraText = extraText;
    }

    public Ingredient getIngredient() {
        return this.ingredient;
    }

    public List<MobEffectInstance> getEffects() {
        return this.effects;
    }

    public int getMaxAmplifier() {
        return this.maxAmplifier;
    }

    public String getExtraText() {
        return this.extraText;
    }

    public boolean m_5818_(Container container, Level level) {
        return false;
    }

    public boolean matches(ItemStack itemStack) {
        return this.ingredient.test(itemStack);
    }

    public ItemStack m_5874_(Container container, RegistryAccess registryAccess) {
        return this.m_8043_(registryAccess);
    }

    public boolean m_8004_(int pWidth, int pHeight) {
        return false;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return ItemStack.f_41583_;
    }

    @Nonnull
    public ResourceLocation m_6423_() {
        return this.id;
    }

    public boolean m_5598_() {
        return true;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ActuallyRecipes.COFFEE_INGREDIENT_RECIPE.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)ActuallyRecipes.Types.COFFEE_INGREDIENT.get();
    }

    public boolean effect(ItemStack stack) {
        return ActuallyAdditionsAPI.methodHandler.addRecipeEffectToStack(stack, this);
    }

    public static Optional<CoffeeIngredientRecipe> getIngredientForStack(ItemStack ingredient) {
        return ActuallyAdditionsAPI.COFFEE_MACHINE_INGREDIENTS.stream().filter(recipe -> recipe.matches(ingredient)).findFirst();
    }

    public record EffectInstance(ResourceLocation effect, int duration, int amplifier) {
        public static final EffectInstance EMPTY = new EffectInstance(new ResourceLocation("darkness"), 0, 0);
        public static final Codec<EffectInstance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.f_135803_.fieldOf("effect").forGetter(effect -> effect.effect), (App)Codec.INT.fieldOf("duration").forGetter(effect -> effect.duration), (App)Codec.INT.fieldOf("amplifier").forGetter(effect -> effect.amplifier)).apply((Applicative)instance, EffectInstance::new));

        public EffectInstance(MobEffectInstance effect) {
            this(BuiltInRegistries.f_256974_.m_7981_((Object)effect.m_19544_()), effect.m_19557_(), effect.m_19564_());
        }

        public static EffectInstance fromNetwork(FriendlyByteBuf pBuffer) {
            ResourceLocation effect = pBuffer.m_130281_();
            int duration = pBuffer.m_130242_();
            int amplifier = pBuffer.m_130242_();
            return new EffectInstance(effect, duration, amplifier);
        }

        public void toNetwork(FriendlyByteBuf pBuffer) {
            pBuffer.m_130085_(this.effect);
            pBuffer.m_130130_(this.duration);
            pBuffer.m_130130_(this.amplifier);
        }
    }

    public static class Result
    implements FinishedRecipe {
        private final ResourceLocation id;
        protected final Ingredient ingredient;
        protected final List<EffectInstance> instances;
        protected final int maxAmplifier;
        protected final String extraText;

        public Result(ResourceLocation id, Ingredient ingredient, List<EffectInstance> effectInstances, int maxAmplifier, String extraText) {
            this.id = id;
            this.ingredient = ingredient;
            this.maxAmplifier = maxAmplifier;
            this.instances = effectInstances;
            this.extraText = extraText;
        }

        public void m_7917_(JsonObject pJson) {
            pJson.add("ingredient", this.ingredient.m_43942_());
            JsonArray effectArray = new JsonArray();
            for (EffectInstance effect : this.instances) {
                effectArray.add((JsonElement)EffectInstance.CODEC.encode((Object)effect, (DynamicOps)JsonOps.INSTANCE, (Object)JsonOps.INSTANCE.empty()).getOrThrow(false, e -> {
                    throw new IllegalStateException((String)e);
                }));
            }
            pJson.add("effects", (JsonElement)effectArray);
            pJson.addProperty("maxAmplifier", (Number)this.maxAmplifier);
            pJson.addProperty("extraText", this.extraText);
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)ActuallyRecipes.COFFEE_INGREDIENT_RECIPE.get();
        }

        @Nullable
        public JsonObject m_5860_() {
            return null;
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return null;
        }
    }

    public static class Serializer
    implements RecipeSerializer<CoffeeIngredientRecipe> {
        @NotNull
        public CoffeeIngredientRecipe fromJson(@Nonnull ResourceLocation pRecipeId, @Nonnull JsonObject pJson) {
            Ingredient ingredient = Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)pJson, (String)"ingredient"));
            ArrayList<EffectInstance> effects = pJson.has("effects") ? GsonHelper.m_13933_((JsonObject)pJson, (String)"effects").asList().stream().map(x -> {
                EffectInstance effect = (EffectInstance)((Pair)EffectInstance.CODEC.decode((DynamicOps)JsonOps.INSTANCE, x).getOrThrow(false, e -> {
                    throw new IllegalStateException((String)e);
                })).getFirst();
                if (!BuiltInRegistries.f_256974_.m_7804_(effect.effect)) {
                    throw new IllegalStateException("Unknown effect: " + effect.effect);
                }
                return effect;
            }).toList() : new ArrayList<EffectInstance>();
            int maxAmplifier = GsonHelper.m_13927_((JsonObject)pJson, (String)"maxAmplifier");
            String extraText = GsonHelper.m_13851_((JsonObject)pJson, (String)"extraText", (String)"");
            return new CoffeeIngredientRecipe(pRecipeId, ingredient, effects, maxAmplifier, extraText);
        }

        @Nullable
        public CoffeeIngredientRecipe fromNetwork(@Nonnull ResourceLocation pRecipeId, @Nonnull FriendlyByteBuf pBuffer) {
            Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)pBuffer);
            int i = pBuffer.m_130242_();
            NonNullList list = NonNullList.m_122780_((int)i, (Object)EffectInstance.EMPTY);
            for (int j = 0; j < list.size(); ++j) {
                list.set(j, (Object)EffectInstance.fromNetwork(pBuffer));
            }
            int maxAmplifier = pBuffer.readInt();
            String extraText = pBuffer.m_130136_(Short.MAX_VALUE);
            return new CoffeeIngredientRecipe(pRecipeId, ingredient, (List<EffectInstance>)list, maxAmplifier, extraText);
        }

        public void toNetwork(@Nonnull FriendlyByteBuf pBuffer, CoffeeIngredientRecipe pRecipe) {
            pRecipe.ingredient.m_43923_(pBuffer);
            pBuffer.m_130130_(pRecipe.instances.size());
            for (EffectInstance effect : pRecipe.instances) {
                effect.toNetwork(pBuffer);
            }
            pBuffer.writeInt(pRecipe.maxAmplifier);
            pBuffer.m_130070_(pRecipe.extraText);
        }
    }
}

