/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.crafting;

import de.ellpeck.actuallyadditions.mod.crafting.CoffeeIngredientRecipe;
import de.ellpeck.actuallyadditions.mod.crafting.ColorChangeRecipe;
import de.ellpeck.actuallyadditions.mod.crafting.CrushingRecipe;
import de.ellpeck.actuallyadditions.mod.crafting.EmpowererRecipe;
import de.ellpeck.actuallyadditions.mod.crafting.FermentingRecipe;
import de.ellpeck.actuallyadditions.mod.crafting.LaserRecipe;
import de.ellpeck.actuallyadditions.mod.crafting.LiquidFuelRecipe;
import de.ellpeck.actuallyadditions.mod.crafting.MiningLensRecipe;
import de.ellpeck.actuallyadditions.mod.crafting.PressingRecipe;
import de.ellpeck.actuallyadditions.mod.crafting.RecipeKeepDataShaped;
import de.ellpeck.actuallyadditions.mod.crafting.RecipeKeepDataShapeless;
import de.ellpeck.actuallyadditions.mod.crafting.SolidFuelRecipe;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class ActuallyRecipes {
    public static final DeferredRegister<RecipeSerializer<?>> SERIALIZERS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.RECIPE_SERIALIZERS, (String)"actuallyadditions");
    public static final RegistryObject<RecipeSerializer<?>> KEEP_DATA_SHAPED_RECIPE = SERIALIZERS.register(RecipeKeepDataShaped.NAME, RecipeKeepDataShaped.Serializer::new);
    public static final RegistryObject<RecipeSerializer<?>> KEEP_DATA_SHAPELESS_RECIPE = SERIALIZERS.register(RecipeKeepDataShapeless.NAME, RecipeKeepDataShapeless.Serializer::new);
    public static final Supplier<RecipeSerializer<?>> LASER_RECIPE = SERIALIZERS.register(LaserRecipe.NAME, LaserRecipe.Serializer::new);
    public static final RegistryObject<RecipeSerializer<?>> EMPOWERING_RECIPE = SERIALIZERS.register(EmpowererRecipe.NAME, EmpowererRecipe.Serializer::new);
    public static final RegistryObject<RecipeSerializer<?>> CRUSHING_RECIPE = SERIALIZERS.register(CrushingRecipe.NAME, CrushingRecipe.Serializer::new);
    public static final RegistryObject<RecipeSerializer<?>> SOLID_FUEL_RECIPE = SERIALIZERS.register(SolidFuelRecipe.NAME, SolidFuelRecipe.Serializer::new);
    public static final RegistryObject<RecipeSerializer<?>> LIQUID_FUEL_RECIPE = SERIALIZERS.register(LiquidFuelRecipe.NAME, LiquidFuelRecipe.Serializer::new);
    public static final RegistryObject<RecipeSerializer<?>> PRESSING_RECIPE = SERIALIZERS.register("pressing", PressingRecipe.Serializer::new);
    public static final RegistryObject<RecipeSerializer<?>> FERMENTING_RECIPE = SERIALIZERS.register("fermenting", FermentingRecipe.Serializer::new);
    public static final RegistryObject<RecipeSerializer<?>> COLOR_CHANGE_RECIPE = SERIALIZERS.register("color_change", ColorChangeRecipe.Serializer::new);
    public static final RegistryObject<RecipeSerializer<?>> MINING_LENS_RECIPE = SERIALIZERS.register("mining_lens", MiningLensRecipe.Serializer::new);
    public static final RegistryObject<RecipeSerializer<?>> COFFEE_INGREDIENT_RECIPE = SERIALIZERS.register("coffee_ingredient", CoffeeIngredientRecipe.Serializer::new);

    public static void init(IEventBus bus) {
        SERIALIZERS.register(bus);
        Types.RECIPE_TYPES.register(bus);
    }

    private static <T extends Recipe<?>> Supplier<RecipeType<T>> recipeType(String name) {
        return () -> RecipeType.simple((ResourceLocation)new ResourceLocation("actuallyadditions", name));
    }

    public static class Types {
        public static final DeferredRegister<RecipeType<?>> RECIPE_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.RECIPE_TYPES, (String)"actuallyadditions");
        public static final RegistryObject<RecipeType<LaserRecipe>> LASER = RECIPE_TYPES.register("laser", ActuallyRecipes.recipeType("laser"));
        public static final RegistryObject<RecipeType<EmpowererRecipe>> EMPOWERING = RECIPE_TYPES.register("empower", ActuallyRecipes.recipeType("empower"));
        public static final RegistryObject<RecipeType<CrushingRecipe>> CRUSHING = RECIPE_TYPES.register("crushing", ActuallyRecipes.recipeType("crushing"));
        public static final RegistryObject<RecipeType<SolidFuelRecipe>> SOLID_FUEL = RECIPE_TYPES.register("solid_fuel", ActuallyRecipes.recipeType("solid_fuel"));
        public static final RegistryObject<RecipeType<LiquidFuelRecipe>> LIQUID_FUEL = RECIPE_TYPES.register("liquid_fuel", ActuallyRecipes.recipeType("liquid_fuel"));
        public static final RegistryObject<RecipeType<PressingRecipe>> PRESSING = RECIPE_TYPES.register("pressing", ActuallyRecipes.recipeType("pressing"));
        public static final RegistryObject<RecipeType<FermentingRecipe>> FERMENTING = RECIPE_TYPES.register("fermenting", ActuallyRecipes.recipeType("fermenting"));
        public static final RegistryObject<RecipeType<ColorChangeRecipe>> COLOR_CHANGE = RECIPE_TYPES.register("color_change", ActuallyRecipes.recipeType("color_change"));
        public static final RegistryObject<RecipeType<MiningLensRecipe>> MINING_LENS = RECIPE_TYPES.register("mining_lens", ActuallyRecipes.recipeType("mining_lens"));
        public static final RegistryObject<RecipeType<CoffeeIngredientRecipe>> COFFEE_INGREDIENT = RECIPE_TYPES.register("coffee_ingredient", ActuallyRecipes.recipeType("coffee_ingredient"));
    }
}

